/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import com.google.common.collect.Iterables;
import gregtech.api.recipe.RecipeMapBackendProperties;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeMapUtil;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class RecipeMapBackendPropertiesBuilder {
    private int minItemInputs;
    private int minFluidInputs;
    private boolean specialSlotSensitive;
    private Consumer<? super GTRecipeBuilder> builderTransformer;
    private Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter = this::defaultBuildRecipe;
    private Consumer<? super GTRecipe> recipeTransformer;

    RecipeMapBackendPropertiesBuilder() {
    }

    RecipeMapBackendProperties build() {
        return new RecipeMapBackendProperties(this.minItemInputs, this.minFluidInputs, this.specialSlotSensitive, this.recipeEmitter, this.builderTransformer, this.recipeTransformer);
    }

    public RecipeMapBackendPropertiesBuilder minItemInputs(int minItemInputs) {
        this.minItemInputs = minItemInputs;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder minFluidInputs(int minFluidInputs) {
        this.minFluidInputs = minFluidInputs;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder specialSlotSensitive() {
        this.specialSlotSensitive = true;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder recipeEmitter(Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> recipeEmitter) {
        this.recipeEmitter = recipeEmitter;
        return this;
    }

    public RecipeMapBackendPropertiesBuilder combineRecipeEmitter(Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> func) {
        Function<? super GTRecipeBuilder, ? extends Iterable<? extends GTRecipe>> cur = this.recipeEmitter;
        return this.recipeEmitter(b -> Iterables.concat((Iterable)((Iterable)cur.apply((GTRecipeBuilder)b)), (Iterable)((Iterable)func.apply((GTRecipeBuilder)b))));
    }

    public RecipeMapBackendPropertiesBuilder builderTransformer(Consumer<? super GTRecipeBuilder> builderTransformer) {
        if (this.builderTransformer == null) {
            this.builderTransformer = builderTransformer;
        } else {
            Consumer<? super GTRecipeBuilder> t = this.builderTransformer;
            this.builderTransformer = b -> {
                t.accept((GTRecipeBuilder)b);
                builderTransformer.accept((GTRecipeBuilder)b);
            };
        }
        return this;
    }

    private Iterable<? extends GTRecipe> defaultBuildRecipe(GTRecipeBuilder builder) {
        GTRecipeBuilder b = builder;
        b = RecipeMapBackendPropertiesBuilder.copy(builder, b);
        return GTRecipeMapUtil.buildOrEmpty(b);
    }

    private static GTRecipeBuilder copy(GTRecipeBuilder original, GTRecipeBuilder b) {
        return b == original ? b.copy() : b;
    }

    public RecipeMapBackendPropertiesBuilder recipeTransformer(Consumer<? super GTRecipe> recipeTransformer) {
        if (this.recipeTransformer == null) {
            this.recipeTransformer = recipeTransformer;
        } else {
            Consumer<? super GTRecipe> t = this.recipeTransformer;
            this.recipeTransformer = r -> {
                t.accept((GTRecipe)r);
                recipeTransformer.accept((GTRecipe)r);
            };
        }
        return this;
    }
}

