/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.widget.builder;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IBoolValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.widgets.ToggleButton;
import com.cleanroommc.modularui.widgets.layout.Flow;
import gregtech.api.interfaces.modularui.KeyProvider;
import gregtech.common.modularui2.sync.LinkedBoolValue;
import gregtech.common.modularui2.widget.SelectButton;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class EnumRowBuilder<E extends Enum<E>> {
    private EnumSyncValue<E> syncValue;
    @NotNull
    private final Class<E> enumClass;
    private IDrawable[] overlay;
    private IKey[] tooltip;

    public EnumRowBuilder(@NotNull Class<E> enumClass) {
        this.enumClass = Objects.requireNonNull(enumClass);
    }

    public EnumRowBuilder<E> value(EnumSyncValue<E> syncValue) {
        this.syncValue = syncValue;
        return this;
    }

    public EnumRowBuilder<E> overlay(IDrawable ... overlay) {
        this.overlay = overlay;
        return this;
    }

    public EnumRowBuilder<E> overlay(int size, IDrawable ... overlay) {
        this.overlay = new IDrawable[overlay.length];
        for (int i = 0; i < overlay.length; ++i) {
            this.overlay[i] = overlay[i].asIcon().size(size);
        }
        return this;
    }

    public EnumRowBuilder<E> tooltip(IKey ... tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public Flow build() {
        if (this.syncValue == null) {
            throw new IllegalArgumentException("Sync value cannot be null");
        }
        if (this.overlay != null && this.overlay.length != ((Enum[])this.enumClass.getEnumConstants()).length) {
            throw new IllegalArgumentException("Number of overlays must be " + ((Enum[])this.enumClass.getEnumConstants()).length);
        }
        if (this.tooltip != null && this.tooltip.length != ((Enum[])this.enumClass.getEnumConstants()).length) {
            throw new IllegalArgumentException("Number of tooltips must be " + ((Enum[])this.enumClass.getEnumConstants()).length);
        }
        Flow row = (Flow)Flow.row().childPadding(2).coverChildren();
        for (Enum enumVal : (Enum[])this.enumClass.getEnumConstants()) {
            ToggleButton button = (ToggleButton)new SelectButton().value((IBoolValue)LinkedBoolValue.of(this.syncValue, enumVal)).size(16);
            if (this.overlay != null) {
                button.overlay(new IDrawable[]{this.overlay[enumVal.ordinal()]});
            }
            if (this.tooltip != null) {
                button.addTooltipLine((IDrawable)this.tooltip[enumVal.ordinal()]);
            }
            if (enumVal instanceof KeyProvider) {
                KeyProvider keyProvider = (KeyProvider)((Object)enumVal);
                button.addTooltipLine((IDrawable)keyProvider.getKey());
            }
            row.child((IWidget)button);
        }
        return row;
    }
}

