/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.DimensionalCoord;
import appeng.core.worlddata.WorldData;
import appeng.items.misc.ItemEncodedPattern;
import appeng.me.GridAccessException;
import appeng.me.GridNode;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.net.GTPacketLMACraftingFX;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTELargeMolecularAssembler
extends MTEExtendedPowerMultiBlockBase<MTELargeMolecularAssembler>
implements ICraftingProvider,
IActionHost,
IGridProxyable,
ISurvivalConstructable {
    private static final String DATA_ORB_JOBS_KEY = "MX-CraftingJobs";
    private static final String DATA_ORB_JOBS_JOB_KEY = "Job";
    private static final String MACHINE_TYPE = "Molecular Assembler, LMA";
    private static final int EU_PER_TICK_BASIC = 16;
    private static final int EU_PER_TICK_CRAFTING = 64;
    private static final int CASING_INDEX = 48;
    private static final int MIN_CASING_COUNT = 24;
    private static final String DATA_ORB_TITLE = "AE-JOBS";
    private static final String NBT_KEY_CACHED_OUTPUTS = "cachedOutputs";
    private static final String NBT_KEY_CONFIG_HIDDEN_CRAFTING_FX = "config:hiddenCraftingFX";
    private static final int STRUCTURE_HORIZONTAL_OFFSET = 2;
    private static final int STRUCTURE_VERTICAL_OFFSET = 4;
    private static final int STRUCTURE_DEPTH_OFFSET = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTELargeMolecularAssembler> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"CCCCC", "CGGGC", "CGGGC", "CGGGC", "CCCCC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CGGGC", "G---G", "G-X-G", "G---G", "CGGGC"}, {"CGGGC", "G---G", "G---G", "G---G", "CGGGC"}, {"CC~CC", "CGGGC", "CGGGC", "CGGGC", "CCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTELargeMolecularAssembler.class).atLeast(HatchElement.Energy, HatchElement.InputBus, HatchElement.Maintenance).casingIndex(48).dot(1).build(), StructureUtility.onElementPass(it -> {
        it.casing = (byte)(it.casing + 1);
    }, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0))})).addElement('G', StructureUtility.ofBlockAnyMeta((Block)((Block)AEApi.instance().definitions().blocks().quartzVibrantGlass().maybeBlock().get()))).addElement('X', (IStructureElement)((IStructureElementCheckOnly)(mte, world, x, y, z) -> {
        if (world.func_147437_c(x, y, z)) {
            mte.craftingDisplayPoint = new CraftingDisplayPoint(world, x, y, z);
            return true;
        }
        return false;
    })).build();
    private byte casing;
    private CraftingDisplayPoint craftingDisplayPoint;
    private ItemStack cachedDataOrb;
    private List<List<ItemStack>> cachedAeJobs = new ArrayList<List<ItemStack>>();
    private boolean aeJobsDirty;
    private List<ICraftingPatternDetails> cachedPatternDetails = new ArrayList<ICraftingPatternDetails>();
    private Map<ItemStack, Pair<NBTTagCompound, ICraftingPatternDetails>> patternDetailCache = new IdentityHashMap<ItemStack, Pair<NBTTagCompound, ICraftingPatternDetails>>();
    private BaseActionSource requestSource;
    private IItemList<IAEItemStack> cachedOutputs = AEApi.instance().storage().createPrimitiveItemList();
    private boolean lastOutputFailed;
    private long lastOutputTick;
    private long tickCounter;
    public boolean hiddenCraftingFX;
    private AENetworkProxy gridProxy;

    public MTELargeMolecularAssembler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeMolecularAssembler(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargeMolecularAssembler(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_ME_HATCH).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48)};
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        return this.withAeJobs(($, aeJobs) -> {
            this.mMaxProgresstime = 20;
            long craftingProgressTime = 20L;
            long craftingEUt = 64L;
            this.lEUt = -16L;
            int extraTier = Math.max(0, GTUtility.getTier(this.getMaxInputVoltage()) - 2);
            for (int i = 0; i < 2 && extraTier > 0; --extraTier, ++i) {
                craftingProgressTime /= 2L;
                craftingEUt *= 4L;
            }
            int parallel = 2 << extraTier;
            craftingEUt <<= 2 * extraTier;
            ArrayList outputs = new ArrayList();
            for (List l : aeJobs.subList(0, Math.min(parallel, aeJobs.size()))) {
                outputs.addAll(l);
            }
            if (!outputs.isEmpty()) {
                aeJobs.subList(0, Math.min(parallel, aeJobs.size())).clear();
                this.aeJobsDirty = true;
                this.lEUt = -craftingEUt;
                this.mMaxProgresstime = (int)craftingProgressTime;
                this.mOutputItems = outputs.toArray(new ItemStack[0]);
                this.addCraftingFX((ItemStack)outputs.get(0));
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            return true;
        });
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        IAEItemStack aeIS;
        this.saveAeJobsIfNeeded();
        super.saveNBTData(aNBT);
        NBTTagList isList = new NBTTagList();
        Iterator iterator = this.cachedOutputs.iterator();
        while (iterator.hasNext() && (aeIS = (IAEItemStack)iterator.next()).getStackSize() > 0L) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound isTag = new NBTTagCompound();
            aeIS.getItemStack().func_77955_b(isTag);
            tag.func_74782_a("itemStack", (NBTBase)isTag);
            tag.func_74772_a("size", aeIS.getStackSize());
            isList.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74782_a(NBT_KEY_CACHED_OUTPUTS, (NBTBase)isList);
        aNBT.func_74757_a(NBT_KEY_CONFIG_HIDDEN_CRAFTING_FX, this.hiddenCraftingFX);
        NBTTagCompound proxyTag = new NBTTagCompound();
        this.getProxy().writeToNBT(proxyTag);
        aNBT.func_74782_a("proxy", (NBTBase)proxyTag);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTBase nbtBase = aNBT.func_74781_a(NBT_KEY_CACHED_OUTPUTS);
        if (nbtBase instanceof NBTTagList) {
            NBTTagList isList = (NBTTagList)nbtBase;
            for (int i = 0; i < isList.func_74745_c(); ++i) {
                NBTTagCompound tag = isList.func_150305_b(i);
                NBTTagCompound isTag = tag.func_74775_l("itemStack");
                long size = tag.func_74763_f("size");
                ItemStack itemStack = GTUtility.loadItem(isTag);
                IAEItemStack aeIS = AEApi.instance().storage().createItemStack(itemStack);
                aeIS.setStackSize(size);
                this.cachedOutputs.add((IAEStack)aeIS);
            }
        }
        this.hiddenCraftingFX = aNBT.func_74767_n(NBT_KEY_CONFIG_HIDDEN_CRAFTING_FX);
        if (aNBT.func_74764_b("proxy")) {
            this.getProxy().readFromNBT(aNBT.func_74775_l("proxy"));
        }
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        return new MultiblockTooltipBuilder().addMachineType(MACHINE_TYPE).addInfo("Needs a Data Orb to be placed in the controller").addInfo("Basic: " + EnumChatFormatting.GREEN + 16 + EnumChatFormatting.GRAY + " EU/t, unaffected by overclocking").addInfo("Crafting: " + EnumChatFormatting.GREEN + 64 + EnumChatFormatting.GRAY + " EU/t, Finish " + EnumChatFormatting.WHITE + "2" + EnumChatFormatting.GRAY + " Jobs in " + EnumChatFormatting.WHITE + "1" + EnumChatFormatting.GRAY + "s").addInfo("The first two Overclocks:").addInfo("-Reduce the Finish time to " + EnumChatFormatting.WHITE + "0.5" + EnumChatFormatting.GRAY + "s and " + EnumChatFormatting.WHITE + "0.25" + EnumChatFormatting.GRAY + "s").addInfo("Subsequent Overclocks:").addInfo("-Double the number of Jobs finished at once").beginStructureBlock(5, 5, 5, true).addController("Front center").addCasingInfoMin("Robust Tungstensteel Machine Casing", 24, false).addCasingInfoExactly(((Block)AEApi.instance().definitions().blocks().quartzVibrantGlass().maybeBlock().get()).func_149732_F(), 54, false).addInputBus("Any casing", 1).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).toolTipFinisher(new String[0]);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 4, 0)) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mEnergyHatches.isEmpty()) {
            return false;
        }
        return this.casing >= 24;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 4, 0, elementBudget, env, false, true);
    }

    @Override
    public IStructureDefinition<MTELargeMolecularAssembler> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean addOutput(ItemStack aStack) {
        this.cachedOutputs.add((IAEStack)AEApi.instance().storage().createItemStack(aStack));
        this.func_70296_d();
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.flushCachedOutputsIfNeeded(aTick);
            this.saveAeJobsIfNeeded();
            this.syncAEProxyActive(aBaseMetaTileEntity);
            this.issuePatternChangeIfNeeded(aTick);
        }
    }

    private boolean withAeJobs(BiFunction<ItemStack, List<List<ItemStack>>, Boolean> action) {
        if (this.mInventory[1] == this.cachedDataOrb && this.cachedDataOrb != null) {
            return action.apply(this.cachedDataOrb, this.cachedAeJobs);
        }
        if (!ItemList.Tool_DataOrb.isStackEqual(this.mInventory[1], false, true)) {
            this.cachedDataOrb = null;
            this.cachedAeJobs = null;
            return false;
        }
        ItemStack dataOrb = this.mInventory[1];
        String dataTitle = BehaviourDataOrb.getDataTitle(dataOrb);
        if (dataTitle == null || dataTitle.isEmpty()) {
            dataTitle = DATA_ORB_TITLE;
            BehaviourDataOrb.setDataName(dataOrb, dataTitle);
            BehaviourDataOrb.setNBTInventory(dataOrb, GTValues.emptyItemStackArray);
        }
        if (!dataTitle.equals(DATA_ORB_TITLE)) {
            this.cachedDataOrb = null;
            this.cachedAeJobs = null;
            return false;
        }
        this.cachedDataOrb = dataOrb;
        NBTTagCompound tag = dataOrb.func_77978_p();
        if (tag != null && tag.func_150297_b("Inventory", 9)) {
            ItemStack[] stacks;
            ArrayList<List<ItemStack>> jobs = new ArrayList<List<ItemStack>>();
            for (ItemStack stack : stacks = BehaviourDataOrb.getNBTInventory(dataOrb)) {
                if (stack == null) continue;
                ArrayList<ItemStack> l = new ArrayList<ItemStack>();
                l.add(stack);
                jobs.add(l);
            }
            this.cachedAeJobs = jobs;
        } else if (tag != null && tag.func_150297_b(DATA_ORB_JOBS_KEY, 9)) {
            ArrayList<List<ItemStack>> jobs = new ArrayList<List<ItemStack>>();
            NBTTagList tagList = tag.func_150295_c(DATA_ORB_JOBS_KEY, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound jobTag = tagList.func_150305_b(i);
                NBTTagList jobTagList = jobTag.func_150295_c(DATA_ORB_JOBS_JOB_KEY, 10);
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int j = 0; j < jobTagList.func_74745_c(); ++j) {
                    ItemStack stack = GTUtility.loadItem(jobTagList.func_150305_b(j));
                    stacks.add(stack);
                }
                jobs.add(stacks);
            }
            this.cachedAeJobs = jobs;
        } else {
            this.cachedAeJobs = new ArrayList<List<ItemStack>>();
        }
        return action.apply(this.cachedDataOrb, this.cachedAeJobs);
    }

    private void addCraftingFX(ItemStack itemStack) {
        if (this.hiddenCraftingFX) {
            return;
        }
        if (this.craftingDisplayPoint != null) {
            GTValues.NW.sendToAllAround(new GTPacketLMACraftingFX(this.craftingDisplayPoint.x, this.craftingDisplayPoint.y, this.craftingDisplayPoint.z, this.mMaxProgresstime, AEApi.instance().storage().createItemStack(itemStack)), new NetworkRegistry.TargetPoint(((CraftingDisplayPoint)this.craftingDisplayPoint).w.field_73011_w.field_76574_g, (double)this.craftingDisplayPoint.x, (double)this.craftingDisplayPoint.y, (double)this.craftingDisplayPoint.z, 64.0));
        }
    }

    private BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    private void flushCachedOutputsIfNeeded(long tick) {
        this.tickCounter = tick;
        if (this.tickCounter <= this.lastOutputTick + 40L) {
            return;
        }
        this.lastOutputFailed = true;
        try {
            AENetworkProxy proxy = this.getProxy();
            if (proxy == null) {
                return;
            }
            IMEMonitor storage = proxy.getStorage().getItemInventory();
            for (IAEItemStack s : this.cachedOutputs) {
                if (s.getStackSize() == 0L) continue;
                IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)storage, (IAEStack)s, (BaseActionSource)this.getRequest());
                if (rest != null && rest.getStackSize() > 0L) {
                    this.lastOutputFailed = true;
                    s.setStackSize(rest.getStackSize());
                    break;
                }
                s.setStackSize(0L);
            }
        }
        catch (GridAccessException ignored) {
            this.lastOutputFailed = true;
        }
        this.lastOutputTick = this.tickCounter;
    }

    private void saveAeJobsIfNeeded() {
        if (!this.aeJobsDirty) {
            return;
        }
        this.withAeJobs((dataOrb, aeJobs) -> {
            NBTTagList jobList = new NBTTagList();
            for (List job : aeJobs) {
                NBTTagCompound jobTag = new NBTTagCompound();
                NBTTagList itemList = new NBTTagList();
                for (ItemStack item : job) {
                    itemList.func_74742_a((NBTBase)GTUtility.saveItem(item));
                }
                jobTag.func_74782_a(DATA_ORB_JOBS_JOB_KEY, (NBTBase)itemList);
            }
            dataOrb.field_77990_d.func_74782_a(DATA_ORB_JOBS_KEY, (NBTBase)jobList);
            this.func_70296_d();
            this.aeJobsDirty = false;
            return true;
        });
    }

    private void issuePatternChangeIfNeeded(long tick) {
        if (tick % 20L != 0L) {
            return;
        }
        Set inputs = GTUtility.filterValidMTEs(this.mInputBusses).stream().filter(bus -> !(bus instanceof MTEHatchCraftingInputME)).flatMap(bus -> IntStream.range(0, bus.func_70302_i_()).mapToObj(bus::func_70301_a)).filter(Objects::nonNull).collect(Collectors.toSet());
        List patterns = inputs.stream().map(is -> {
            Item patt22190$temp = is.func_77973_b();
            if (!(patt22190$temp instanceof ItemEncodedPattern)) {
                return null;
            }
            ItemEncodedPattern pattern = (ItemEncodedPattern)patt22190$temp;
            Pair<NBTTagCompound, ICraftingPatternDetails> entry = this.patternDetailCache.get(is);
            if (entry == null || !Objects.equals(is.func_77978_p(), entry.getKey())) {
                ICraftingPatternDetails detail = pattern.getPatternForItem(is, this.getBaseMetaTileEntity().getWorld());
                this.patternDetailCache.put((ItemStack)is, (Pair<NBTTagCompound, ICraftingPatternDetails>)Pair.of((Object)is.func_77978_p(), (Object)detail));
                return detail;
            }
            return (ICraftingPatternDetails)entry.getValue();
        }).filter(Objects::nonNull).filter(it -> it.isCraftable()).collect(Collectors.toList());
        if (patterns.equals(this.cachedPatternDetails)) {
            return;
        }
        this.cachedPatternDetails = patterns;
        this.patternDetailCache.keySet().retainAll(inputs);
        try {
            AENetworkProxy proxy = this.getProxy();
            if (proxy == null) {
                return;
            }
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void syncAEProxyActive(IGregTechTileEntity baseMetaTileEntity) {
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            return;
        }
        if (baseMetaTileEntity.isActive()) {
            if (!proxy.isReady()) {
                proxy.onReady();
                IGridNode node = proxy.getNode();
                if (node == null) {
                    return;
                }
                if (node.getPlayerID() == -1) {
                    GTLog.out.printf("Found a LMA at %s without valid AE playerID.\n", ((BaseMetaTileEntity)baseMetaTileEntity).getLocation());
                    GTLog.out.println("Try to recover playerID with UUID: " + baseMetaTileEntity.getOwnerUuid());
                    int playerAEID = WorldData.instance().playerData().getPlayerID(new GameProfile(baseMetaTileEntity.getOwnerUuid(), baseMetaTileEntity.getOwnerName()));
                    node.setPlayerID(playerAEID);
                    ((GridNode)node).setLastSecurityKey(-1L);
                    node.updateState();
                    GTLog.out.println("Now it has playerID: " + playerAEID);
                }
            }
            if (proxy.getConnectableSides().isEmpty()) {
                proxy.setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
            }
        } else if (!proxy.getConnectableSides().isEmpty()) {
            proxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        }
    }

    private boolean addToLargeMolecularAssemblerList(IGregTechTileEntity tileEntity, short baseCasingIndex) {
        if (this.addMaintenanceToMachineList(tileEntity, baseCasingIndex)) {
            return true;
        }
        if (this.addInputToMachineList(tileEntity, baseCasingIndex)) {
            return true;
        }
        return this.addEnergyInputToMachineList(tileEntity, baseCasingIndex);
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        return this.withAeJobs(($, aeJobs) -> {
            World w = this.getBaseMetaTileEntity().getWorld();
            ItemStack mainOutput = patternDetails.getOutput(table, w);
            if (mainOutput == null) {
                return false;
            }
            FMLCommonHandler.instance().firePlayerCraftingEvent(Platform.getPlayer((WorldServer)((WorldServer)w)), mainOutput, (IInventory)table);
            List leftover = IntStream.range(0, table.func_70302_i_() + 1).mapToObj(i -> Platform.getContainerItem((ItemStack)table.func_70301_a(i))).filter(Objects::nonNull).collect(Collectors.toList());
            leftover.add(mainOutput);
            aeJobs.add(leftover);
            this.aeJobsDirty = true;
            return true;
        });
    }

    public boolean isBusy() {
        return this.withAeJobs(($, aeJobs) -> aeJobs.size() >= 256);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            return;
        }
        if (proxy.isReady()) {
            for (ICraftingPatternDetails detail : this.cachedPatternDetails) {
                craftingTracker.addCraftingOption((ICraftingMedium)this, detail);
            }
        }
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", this.getStackForm(1L), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                EntityPlayer player = this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName());
                this.gridProxy.setOwner(player);
            }
        }
        return this.gridProxy;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            return null;
        }
        return proxy.getNode();
    }

    public void securityBreak() {
        this.getBaseMetaTileEntity().disableWorking();
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            this.hiddenCraftingFX = !this.hiddenCraftingFX;
        }).setPlayClickSound(true).setBackground(() -> {
            ArrayList<UITexture> ret = new ArrayList<UITexture>();
            if (this.hiddenCraftingFX) {
                ret.add(GTUITextures.BUTTON_STANDARD);
                ret.add(GTUITextures.OVERLAY_BUTTON_LMA_ANIMATION_OFF);
            } else {
                ret.add(GTUITextures.BUTTON_STANDARD_PRESSED);
                ret.add(GTUITextures.OVERLAY_BUTTON_LMA_ANIMATION_ON);
            }
            return ret.toArray(new IDrawable[0]);
        }).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> this.hiddenCraftingFX, val -> {
            this.hiddenCraftingFX = val;
        }), (IWidgetBuilder)builder).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.text.lma_craftingfx")).setTooltipShowUpDelay(5).setPos(80, 91).setSize(16, 16));
    }

    private static class CraftingDisplayPoint {
        private final World w;
        private final int x;
        private final int y;
        private final int z;

        private CraftingDisplayPoint(World w, int x, int y, int z) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

