/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.drone;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.common.tileentities.machines.multi.drone.DroneConnection;
import gregtech.common.tileentities.machines.multi.drone.MTEDroneCentre;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchDroneDownLink
extends MTEHatchMaintenance {
    private Vec3Impl downlinkCoord;
    private MTEDroneCentre center;
    private final Set<DroneConnection> connections = new HashSet<DroneConnection>();
    private final Set<MTEMultiBlockBase> machines = new HashSet<MTEMultiBlockBase>();
    private static final IIconContainer moduleActive = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_DRONE_MODULE_ACTIVE");

    public MTEHatchDroneDownLink(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchDroneDownLink(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures, false);
    }

    public void registerMachineController(MTEMultiBlockBase machine) {
        this.machines.add(machine);
        this.addConnection(machine);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Built-in powerful navigation beacon!"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(moduleActive)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(moduleActive)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDroneDownLink(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.downlinkCoord = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
        this.tryFindDroneCenter();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aTick % 80L == 0L) {
                this.validateConnections();
            }
            if (this.center == null && aTick % 200L == 0L) {
                this.tryFindDroneCenter();
            }
            if (this.hasConnection() && this.center.getBaseMetaTileEntity().isActive()) {
                this.doNormalMaintain();
            }
        }
    }

    private void validateConnections() {
        if (!(this.center == null || this.center.isValid() && this.center.getBaseMetaTileEntity().isActive())) {
            this.center.getConnectionList().removeAll(this.connections);
            this.connections.clear();
            this.center = null;
        }
        for (MTEMultiBlockBase machine : new ArrayList<MTEMultiBlockBase>(this.machines)) {
            if (machine.isValid()) continue;
            this.machines.remove(machine);
            DroneConnection connection = this.findConnection(machine);
            this.connections.remove(connection);
            this.center.getConnectionList().remove(connection);
        }
    }

    private void doNormalMaintain() {
        this.mSolderingTool = true;
        this.mCrowbar = true;
        this.mHardHammer = true;
        this.mSoftMallet = true;
        this.mScrewdriver = true;
        this.mWrench = true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (side == aBaseMetaTileEntity.getFrontFacing()) {
            if (aPlayer instanceof FakePlayer) {
                return false;
            }
            if (!this.hasConnection()) {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.noconnection", new Object[0]));
                return true;
            }
            this.openGui(aPlayer);
            return true;
        }
        return false;
    }

    @Override
    public void onMaintenancePerformed(MTEMultiBlockBase aMaintenanceTarget) {
        if (this.mMaintenanceSound == null) {
            this.setMaintenanceSound(SoundResource.GT_MAINTENANCE_DRONE_DOWNLINK_HATCH, 1.0f, 1.0f);
        }
        super.onMaintenancePerformed(aMaintenanceTarget);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onRemoval() {
        if (this.center == null) {
            return;
        }
        this.center.getConnectionList().removeAll(this.connections);
    }

    private boolean hasConnection() {
        this.validateConnections();
        return !this.connections.isEmpty();
    }

    private void tryFindDroneCenter() {
        if (MTEDroneCentre.getCentreMap().containsKey((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
            List target = MTEDroneCentre.getCentreMap().get((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g).stream().collect(Collectors.toList());
            for (MTEDroneCentre centre : target) {
                if (!centre.getCoords().withinDistance(this.downlinkCoord, (double)centre.getRange()) || !centre.getBaseMetaTileEntity().isActive()) continue;
                this.connections.clear();
                this.center = centre;
                for (MTEMultiBlockBase machine : this.machines) {
                    this.addConnection(machine);
                }
                return;
            }
        }
    }

    private void addConnection(MTEMultiBlockBase machine) {
        if (this.center == null || this.findConnection(machine) != null) {
            return;
        }
        DroneConnection connection = new DroneConnection(machine, this.center);
        this.connections.add(connection);
        this.center.getConnectionList().add(connection);
    }

    private DroneConnection findConnection(MTEMultiBlockBase machine) {
        return this.connections.stream().filter(c -> c.machine == machine).findFirst().orElse(null);
    }

    @Override
    public boolean doesBindPlayerInventory() {
        return false;
    }

    @Override
    public int getGUIWidth() {
        return 150;
    }

    @Override
    public int getGUIHeight() {
        return 40;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(135, 3))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.drone_custom_name")).setTextAlignment(Alignment.Center).setPos(0, 5).setSize(150, 8))).widget(new TextFieldWidget().setGetter(() -> this.getFirstConnection() == null ? "" : this.getFirstConnection().getCustomName(false)).setSetter(var -> this.connections.forEach(c -> c.setCustomName((String)var))).setTextAlignment(Alignment.CenterLeft).setTextColor(Color.WHITE.dark(1)).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD_LIGHT_GRAY.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 16).setSize(130, 16))).build();
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("connected", this.hasConnection());
        if (this.hasConnection()) {
            tag.func_74768_a("x", this.center.getCoords().get0());
            tag.func_74768_a("y", this.center.getCoords().get1());
            tag.func_74768_a("z", this.center.getCoords().get2());
            DroneConnection firstConnection = this.getFirstConnection();
            if (firstConnection != null && firstConnection.customName != null) {
                tag.func_74778_a("name", firstConnection.customName);
            }
        }
    }

    private DroneConnection getFirstConnection() {
        return this.connections.stream().findFirst().orElse(null);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("connected")) {
            currenttip.add(EnumChatFormatting.AQUA + StatCollector.func_74837_a((String)"GT5U.waila.drone_downlink.connection", (Object[])new Object[]{tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")}));
            if (tag.func_74764_b("name")) {
                currenttip.add(EnumChatFormatting.YELLOW + tag.func_74779_i("name"));
            }
        } else {
            currenttip.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.waila.drone_downlink.noConnection"));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }
}

