/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.base;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.item.base.itemblock.ItemBlockGtBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class BlockBaseModular
extends BasicBlock {
    protected gtPlusPlus.core.material.Material field_149764_J;
    protected int blockColour;
    public BasicBlock.BlockTypes thisBlock;
    protected String thisBlockMaterial;
    protected String thisBlockMaterialTranslatedName;
    protected final String thisBlockType;
    private static final HashMap<String, Block> sBlockCache = new HashMap();

    public static Block getMaterialBlock(gtPlusPlus.core.material.Material aMaterial, BasicBlock.BlockTypes aType) {
        return sBlockCache.get(aMaterial.getUnlocalizedName() + "." + aType.name());
    }

    public BlockBaseModular(gtPlusPlus.core.material.Material material, BasicBlock.BlockTypes blockType) {
        this(material, blockType, material.getRgbAsHex());
    }

    public BlockBaseModular(gtPlusPlus.core.material.Material material, BasicBlock.BlockTypes blockType, int colour) {
        this(material.getUnlocalizedName(), material.getLocalizedName(), Material.field_151573_f, blockType, colour, Math.min(Math.max(material.vTier, 1), 6));
        this.field_149764_J = material;
        this.registerComponent();
        sBlockCache.put(material.getUnlocalizedName() + "." + blockType.name(), (Block)this);
        this.thisBlockMaterialTranslatedName = material.getTranslatedName();
        GTLanguageManager.addStringLocalization("gtplusplus." + this.func_149739_a() + ".name", this.getProperName());
    }

    protected BlockBaseModular(String unlocalizedName, String blockMaterialString, Material vanillaMaterial, BasicBlock.BlockTypes blockType, int colour, int miningLevel) {
        super(blockType, unlocalizedName, vanillaMaterial, miningLevel);
        this.setHarvestLevel(blockType.getHarvestTool(), miningLevel);
        this.func_149658_d(Mods.GTPlusPlus.ID + ":" + blockType.getTexture());
        this.blockColour = colour == 0 ? Dyes._NULL.toInt() : colour;
        this.thisBlock = blockType;
        this.thisBlockMaterial = blockMaterialString;
        this.thisBlockType = blockType.name().toUpperCase();
        this.func_149663_c(this.getUnlocalizedProperName());
        int fx = this.getBlockTypeMeta();
        GameRegistry.registerBlock((Block)this, ItemBlockGtBlock.class, (String)StringUtils.sanitizeString(blockType.getTexture() + unlocalizedName));
        if (fx == 0) {
            GTOreDictUnificator.registerOre("block" + BlockBaseModular.unifyMaterialName(this.thisBlockMaterial), new ItemStack((Block)this));
        } else if (fx == 1) {
            GTOreDictUnificator.registerOre("frameGt" + BlockBaseModular.unifyMaterialName(this.thisBlockMaterial), new ItemStack((Block)this));
        } else if (fx == 2) {
            GTOreDictUnificator.registerOre("frameGt" + BlockBaseModular.unifyMaterialName(this.thisBlockMaterial), new ItemStack((Block)this));
        }
    }

    public static String unifyMaterialName(String rawMaterName) {
        return rawMaterName.replace(" ", "").replace("-", "").replace("_", "");
    }

    public void registerComponent() {
        int fx;
        String aKey;
        ItemStack x;
        Logger.MATERIALS("Attempting to register " + this.func_149739_a() + ".");
        if (this.field_149764_J == null) {
            Logger.MATERIALS("Tried to register " + this.func_149739_a() + " but the material was null.");
            return;
        }
        String aName = this.field_149764_J.getUnlocalizedName();
        Map<String, ItemStack> aMap = gtPlusPlus.core.material.Material.mComponentMap.get(aName);
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        if ((x = aMap.get(aKey = (fx = this.getBlockTypeMeta()) == 0 ? OrePrefixes.block.name() : (fx == 1 ? OrePrefixes.frameGt.name() : OrePrefixes.ore.name()))) == null) {
            aMap.put(aKey, new ItemStack((Block)this));
            Logger.MATERIALS("Registering a material component. Item: [" + aName + "] Map: [" + aKey + "]");
            gtPlusPlus.core.material.Material.mComponentMap.put(aName, aMap);
        } else {
            Logger.MATERIALS("Tried to double register a material component.");
        }
    }

    public int getBlockTypeMeta() {
        if (this.thisBlockType.equals(BasicBlock.BlockTypes.STANDARD.name().toUpperCase())) {
            return 0;
        }
        if (this.thisBlockType.equals(BasicBlock.BlockTypes.FRAME.name().toUpperCase())) {
            return 1;
        }
        if (this.thisBlockType.equals(BasicBlock.BlockTypes.ORE.name().toUpperCase())) {
            return 2;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        if (this.thisBlock == BasicBlock.BlockTypes.FRAME) {
            return 1;
        }
        return 0;
    }

    public String getProperName() {
        String tempIngot = null;
        if (this.thisBlock == BasicBlock.BlockTypes.STANDARD) {
            tempIngot = "Block of %material";
        } else if (this.thisBlock == BasicBlock.BlockTypes.FRAME) {
            tempIngot = "%material Frame Box";
        } else if (this.thisBlock == BasicBlock.BlockTypes.ORE) {
            tempIngot = "%material Ore [Old]";
        }
        return tempIngot;
    }

    public String getUnlocalizedProperName() {
        return this.getProperName().replace("%s", "%temp").replace("%material", this.thisBlockMaterial).replace("%temp", "%s");
    }

    public String func_149732_F() {
        return GTLanguageManager.getTranslation("gtplusplus." + this.func_149739_a() + ".name").replace("%s", "%temp").replace("%material", this.thisBlockMaterialTranslatedName).replace("%temp", "%s");
    }

    public String func_149739_a() {
        return "block." + this.field_149764_J.getUnlocalizedName() + "." + this.thisBlock.name().toLowerCase();
    }

    public boolean func_149662_c() {
        return false;
    }

    public gtPlusPlus.core.material.Material getMaterialEx() {
        return this.field_149764_J;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIcon) {
        int tier;
        TextureSet u;
        if (!Configuration.visual.useGregtechTextures || this.field_149764_J == null || this.thisBlock == BasicBlock.BlockTypes.ORE) {
            this.field_149761_L = iIcon.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.thisBlock.getTexture());
        }
        String metType = "9j4852jyo3rjmh3owlhw9oe";
        if (this.field_149764_J != null && (u = this.field_149764_J.getTextureSet()) != null) {
            metType = u.mSetName;
        }
        metType = metType.equals("9j4852jyo3rjmh3owlhw9oe") ? "METALLIC" : metType;
        int n = tier = this.field_149764_J != null ? this.field_149764_J.vTier : 0;
        String aType = this.thisBlock == BasicBlock.BlockTypes.FRAME ? "frameGt" : (tier <= 4 ? "block1" : "block5");
        this.field_149761_L = iIcon.func_94245_a(Mods.GregTech.ID + ":materialicons/" + metType + "/" + aType);
    }

    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        return this.blockColour;
    }

    public int func_149741_i(int aMeta) {
        return this.blockColour;
    }

    public int func_149635_D() {
        return this.blockColour;
    }
}

