/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.recipe;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.common.RecipeAdder;
import gtnhintergalactic.recipe.IGRecipeMaps;
import gtnhintergalactic.recipe.SpaceMiningData;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class IG_RecipeAdder
extends RecipeAdder {
    public static IG_RecipeAdder instance = new IG_RecipeAdder();

    public static void init() {
    }

    public static void postInit() {
    }

    @Deprecated
    public static boolean addSpaceResearchRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, ItemStack output, int computationRequiredPerSec, int duration, int EUt, String neededSpaceProject, String neededSpaceProjectLocation) {
        GTRecipeBuilder builder = GTValues.RA.stdBuilder();
        if (aItemInputs != null) {
            builder.itemInputs(aItemInputs);
        }
        if (aFluidInputs != null) {
            builder.fluidInputs(aFluidInputs);
        }
        builder.itemOutputs(output).specialValue(computationRequiredPerSec).duration(duration).eut(EUt);
        if (neededSpaceProject != null && !neededSpaceProject.isEmpty()) {
            builder.metadata(IGRecipeMaps.SPACE_PROJECT, neededSpaceProject);
        }
        if (neededSpaceProjectLocation != null && !neededSpaceProjectLocation.isEmpty()) {
            builder.metadata(IGRecipeMaps.SPACE_LOCATION, neededSpaceProjectLocation);
        }
        builder.addTo(IGRecipeMaps.spaceResearchRecipes);
        return true;
    }

    @Deprecated
    public static boolean addSpaceAssemblerRecipe(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, ItemStack output, int requiredModuleTier, int duration, int EUt, String neededSpaceProject, String neededSpaceProjectLocation) {
        GTRecipeBuilder builder = GTValues.RA.stdBuilder();
        if (aItemInputs != null) {
            builder.itemInputs(aItemInputs);
        }
        if (aFluidInputs != null) {
            builder.fluidInputs(aFluidInputs);
        }
        builder.itemOutputs(output).specialValue(requiredModuleTier).duration(duration).eut(EUt);
        if (neededSpaceProject != null && !neededSpaceProject.isEmpty()) {
            builder.metadata(IGRecipeMaps.SPACE_PROJECT, neededSpaceProject);
        }
        if (neededSpaceProjectLocation != null && !neededSpaceProjectLocation.isEmpty()) {
            builder.metadata(IGRecipeMaps.SPACE_LOCATION, neededSpaceProjectLocation);
        }
        builder.addTo(IGRecipeMaps.spaceAssemblerRecipes);
        return true;
    }

    public static boolean addSpaceMiningRecipe(String asteroidName, ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, Materials[] ores, OrePrefixes orePrefixes, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int recipeWeight) {
        if (ores == null) {
            return false;
        }
        ItemStack[] outputs = new ItemStack[ores.length];
        for (int i = 0; i < ores.length; ++i) {
            outputs[i] = GTOreDictUnificator.get(orePrefixes, ores[i], 64L);
        }
        return IG_RecipeAdder.addSpaceMiningRecipe(asteroidName, aItemInputs, aFluidInputs, aChances, outputs, minSize, maxSize, minDistance, maxDistance, computationRequiredPerSec, minModuleTier, duration, EUt, recipeWeight);
    }

    public static boolean addSpaceMiningRecipe(String asteroidName, ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, ItemStack[] aItemOutputs, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int recipeWeight) {
        if (aItemInputs == null && aFluidInputs == null || aItemOutputs == null) {
            return false;
        }
        if (minDistance > maxDistance || minSize > maxSize) {
            return false;
        }
        if (recipeWeight <= 0) {
            GTLog.err.println("Weight of mining recipe for main material " + aItemOutputs[0].func_77977_a() + " is 0");
        }
        if (aChances != null) {
            if (aChances.length < aItemOutputs.length) {
                return false;
            }
            if (aChances.length > aItemOutputs.length) {
                GTLog.err.println("Chances and outputs of mining recipe for main material " + aItemOutputs[0].func_77977_a() + " have different length!");
            }
            if (Arrays.stream(aChances).sum() != 10000) {
                GTLog.err.println("Sum of chances in mining recipe for main material " + aItemOutputs[0].func_77977_a() + " is not 100%! This will lead to no issue but might be unintentional");
            }
        } else {
            aChances = new int[aItemOutputs.length];
            Arrays.fill(aChances, 10000);
        }
        SpaceMiningData miningData = new SpaceMiningData(asteroidName, minDistance, maxDistance, minSize, maxSize, computationRequiredPerSec, recipeWeight);
        GTRecipeBuilder builder = GTValues.RA.stdBuilder();
        if (aItemInputs != null) {
            builder.itemInputs(aItemInputs);
        }
        if (aFluidInputs != null) {
            builder.fluidInputs(aFluidInputs);
        }
        builder.itemOutputs(aItemOutputs).outputChances(aChances).metadata(IGRecipeMaps.MODULE_TIER, minModuleTier).metadata(IGRecipeMaps.SPACE_MINING_DATA, miningData).duration(duration).eut(EUt).addTo(IGRecipeMaps.spaceMiningRecipes);
        return true;
    }
}

