/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.register;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.common.misc.GTStructureChannels;
import gtnhlanth.common.beamline.MTEBeamlinePipe;
import gtnhlanth.common.block.BlockAntennaCasing;
import gtnhlanth.common.block.BlockCasing;
import gtnhlanth.common.block.BlockShieldedAccGlass;
import gtnhlanth.common.hatch.MTEBusInputFocus;
import gtnhlanth.common.hatch.MTEHatchInputBeamline;
import gtnhlanth.common.hatch.MTEHatchOutputBeamline;
import gtnhlanth.common.item.ItemLanth;
import gtnhlanth.common.item.ItemParticle;
import gtnhlanth.common.item.ItemPhotolithographicMask;
import gtnhlanth.common.item.MaskList;
import gtnhlanth.common.tileentity.MTEDigester;
import gtnhlanth.common.tileentity.MTEDissolutionTank;
import gtnhlanth.common.tileentity.MTELINAC;
import gtnhlanth.common.tileentity.MTESourceChamber;
import gtnhlanth.common.tileentity.MTESynchrotron;
import gtnhlanth.common.tileentity.MTETargetChamber;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class LanthItemList {
    public static ItemStack DIGESTER;
    public static ItemStack DISSOLUTION_TANK;
    public static ItemStack LINAC;
    public static ItemStack SOURCE_CHAMBER;
    public static ItemStack SYNCHROTRON;
    public static ItemStack TARGET_CHAMBER;
    public static ItemStack BEAMLINE_PIPE;
    public static ItemStack LUV_BEAMLINE_INPUT_HATCH;
    public static ItemStack LUV_BEAMLINE_OUTPUT_HATCH;
    public static ItemStack BEAMLINE_FOCUS_INPUT_BUS;
    public static Item CAPILLARY_EXCHANGE;
    public static Item MM_LATTICE;
    public static Item IRON_COATED_QUARTZ;
    public static Item SUBSTRATE_PRECURSOR;
    public static Item MASK_SUBSTRATE;
    public static Item MASKED_MASK;
    public static Item ETCHED_MASK_1;
    public static Item SILICON_NITRIDE_MEMBRANE;
    public static Item PARTICLE_ITEM;
    public static final Block SHIELDED_ACCELERATOR_CASING;
    public static final Block SHIELDED_ACCELERATOR_GLASS;
    public static final Block ELECTRODE_CASING;
    public static final Block COOLANT_DELIVERY_CASING;
    public static final Block ANTENNA_CASING_T1;
    public static final Block ANTENNA_CASING_T2;
    public static final Block NIOBIUM_CAVITY_CASING;
    public static final Block FOCUS_MANIPULATION_CASING;
    public static final Block FOCUS_HOLDER;
    public static final Block TARGET_RECEPTACLE_CASING;
    public static final Block TARGET_HOLDER;
    public static HashMap<MaskList, Item> maskMap;

    public static void registerGTMTE() {
        DIGESTER = new MTEDigester(10500, "Digester", "Digester").getStackForm(1L);
        DISSOLUTION_TANK = new MTEDissolutionTank(10501, "Dissolution Tank", "Dissolution Tank").getStackForm(1L);
        BEAMLINE_PIPE = new MTEBeamlinePipe(10502, "Beamline Pipe", "Beamline Pipe").getStackForm(1L);
        LUV_BEAMLINE_INPUT_HATCH = new MTEHatchInputBeamline(10503, "LuV Beamline Input Hatch", "LuV Beamline Input Hatch", 6).getStackForm(1L);
        LUV_BEAMLINE_OUTPUT_HATCH = new MTEHatchOutputBeamline(10504, "LuV Beamline Output Hatch", "LuV Beamline Output Hatch", 6).getStackForm(1L);
        BEAMLINE_FOCUS_INPUT_BUS = new MTEBusInputFocus(10509, "Focus Input Bus", "Focus Input Bus").getStackForm(1L);
        LINAC = new MTELINAC(10505, "Linear Accelerator", "Linear Accelerator").getStackForm(1L);
        SOURCE_CHAMBER = new MTESourceChamber(10506, "Source Chamber", "Source Chamber").getStackForm(1L);
        SYNCHROTRON = new MTESynchrotron(10507, "Synchrotron", "Synchrotron").getStackForm(1L);
        TARGET_CHAMBER = new MTETargetChamber(10508, "Target Chamber", "Target Chamber").getStackForm(1L);
    }

    public static void registerTypical() {
        GameRegistry.registerItem((Item)CAPILLARY_EXCHANGE, (String)CAPILLARY_EXCHANGE.func_77658_a());
        GameRegistry.registerItem((Item)MM_LATTICE, (String)MM_LATTICE.func_77658_a());
        GameRegistry.registerItem((Item)IRON_COATED_QUARTZ, (String)IRON_COATED_QUARTZ.func_77658_a());
        GameRegistry.registerItem((Item)MASK_SUBSTRATE, (String)MASK_SUBSTRATE.func_77658_a());
        GameRegistry.registerItem((Item)ETCHED_MASK_1, (String)ETCHED_MASK_1.func_77658_a());
        GameRegistry.registerItem((Item)SUBSTRATE_PRECURSOR, (String)SUBSTRATE_PRECURSOR.func_77658_a());
        GameRegistry.registerItem((Item)MASKED_MASK, (String)MASKED_MASK.func_77658_a());
        GameRegistry.registerItem((Item)PARTICLE_ITEM, (String)"particle");
        GameRegistry.registerBlock((Block)SHIELDED_ACCELERATOR_CASING, (String)SHIELDED_ACCELERATOR_CASING.func_149739_a());
        Textures.BlockIcons.casingTexturePages[12][126] = TextureFactory.of(SHIELDED_ACCELERATOR_CASING);
        GameRegistry.registerBlock((Block)ELECTRODE_CASING, (String)ELECTRODE_CASING.func_149739_a());
        GameRegistry.registerBlock((Block)COOLANT_DELIVERY_CASING, (String)COOLANT_DELIVERY_CASING.func_149739_a());
        GameRegistry.registerBlock((Block)SHIELDED_ACCELERATOR_GLASS, (String)SHIELDED_ACCELERATOR_GLASS.func_149739_a());
        GameRegistry.registerBlock((Block)ANTENNA_CASING_T1, (String)ANTENNA_CASING_T1.func_149739_a());
        GameRegistry.registerBlock((Block)ANTENNA_CASING_T2, (String)ANTENNA_CASING_T2.func_149739_a());
        GameRegistry.registerBlock((Block)NIOBIUM_CAVITY_CASING, (String)NIOBIUM_CAVITY_CASING.func_149739_a());
        GameRegistry.registerBlock((Block)FOCUS_MANIPULATION_CASING, (String)FOCUS_MANIPULATION_CASING.func_149739_a());
        GameRegistry.registerBlock((Block)FOCUS_HOLDER, (String)FOCUS_HOLDER.func_149739_a());
        GameRegistry.registerBlock((Block)TARGET_RECEPTACLE_CASING, (String)TARGET_RECEPTACLE_CASING.func_149739_a());
        GameRegistry.registerBlock((Block)TARGET_HOLDER, (String)TARGET_HOLDER.func_149739_a());
        for (MaskList mask : MaskList.values()) {
            String english = mask.getEnglishName();
            String descSpectrum = mask.getSpectrum();
            ItemPhotolithographicMask maskItem = new ItemPhotolithographicMask(mask.getName(), mask.getDamage(), descSpectrum);
            GameRegistry.registerItem((Item)maskItem, (String)maskItem.func_77658_a());
            if (!mask.getName().contains("blank")) {
                GTOreDictUnificator.registerOre((Object)((Object)OrePrefixes.mask) + mask.getName().toUpperCase(), new ItemStack((Item)maskItem));
            }
            GTLanguageManager.addStringLocalization(maskItem.func_77658_a() + ".name", "Mask (" + english + ")");
            maskMap.put(mask, maskItem);
        }
        GTStructureChannels.SYNCHROTRON_ANTENNA.registerAsIndicator(new ItemStack(ANTENNA_CASING_T1), 1);
        GTStructureChannels.SYNCHROTRON_ANTENNA.registerAsIndicator(new ItemStack(ANTENNA_CASING_T2), 2);
    }

    static {
        CAPILLARY_EXCHANGE = new ItemLanth("capillary_exchange");
        MM_LATTICE = new ItemLanth("mm_lattice");
        IRON_COATED_QUARTZ = new ItemLanth("iron_quartz_plate");
        SUBSTRATE_PRECURSOR = new ItemLanth("substrate_precursor");
        MASK_SUBSTRATE = new ItemLanth("mask_substrate");
        MASKED_MASK = new ItemLanth("masked_mask_substrate");
        ETCHED_MASK_1 = new ItemLanth("etched_mask1");
        SILICON_NITRIDE_MEMBRANE = new ItemLanth("nitride_gold_membrane");
        PARTICLE_ITEM = new ItemParticle().func_77655_b("particle");
        SHIELDED_ACCELERATOR_CASING = new BlockCasing("shielded_accelerator");
        SHIELDED_ACCELERATOR_GLASS = new BlockShieldedAccGlass();
        ELECTRODE_CASING = new BlockCasing("electrode");
        COOLANT_DELIVERY_CASING = new BlockCasing("coolant_delivery");
        ANTENNA_CASING_T1 = new BlockAntennaCasing(1);
        ANTENNA_CASING_T2 = new BlockAntennaCasing(2);
        NIOBIUM_CAVITY_CASING = new BlockCasing("niobium_cavity");
        FOCUS_MANIPULATION_CASING = new BlockCasing("focus_manipulator");
        FOCUS_HOLDER = new BlockCasing("focus_holder");
        TARGET_RECEPTACLE_CASING = new BlockCasing("target_receptacle");
        TARGET_HOLDER = new BlockCasing("target_holder");
        maskMap = new HashMap();
    }
}

