/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.tileentities;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import kekztech.common.Blocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTESOFuelCellMK2
extends MTEEnhancedMultiBlockBase<MTESOFuelCellMK2>
implements ISurvivalConstructable {
    private final int OXYGEN_PER_SEC = 2000;
    private final int EU_PER_TICK = 24576;
    private final int STEAM_PER_SEC = 96000;
    private int mCasing = 0;
    private static final int CASING_TEXTURE_ID = 48;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTESOFuelCellMK2> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "ccc", "ccc", "ccc", "ccc"}, {"c~c", "geg", "geg", "geg", "cdc"}, {"ccc", "ccc", "ccc", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTESOFuelCellMK2.class).atLeast(HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance).dot(1).casingIndex(48).build(), StructureUtility.onElementPass(te -> ++te.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0))})).addElement('d', HatchElement.Dynamo.newAny(48, 2)).addElement('g', StructureUtility.ofBlockAnyMeta((Block)GameRegistry.findBlock((String)"IC2", (String)"blockAlloyGlass"))).addElement('e', StructureUtility.ofBlockAnyMeta((Block)Blocks.gdcUnit)).build();

    public MTESOFuelCellMK2(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTESOFuelCellMK2(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity var1) {
        return new MTESOFuelCellMK2(this.mName);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public IStructureDefinition<MTESOFuelCellMK2> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Gas Turbine").addInfo("Oxidizes gas fuels to generate electricity without polluting the environment").addInfo("Consumes up to " + GTUtility.formatNumbers(491520L) + "EU worth of fuel with up to 100% efficiency each second").addInfo("Nitrobenzene and other gas fuels above 1M EU/bucket are more efficient").addInfo("Steam production requires the SOFC to heat up completely first").addInfo("Outputs 24576EU/t and 96000L/s Superheated Steam").addInfo("Additionally, requires 2000L/s Oxygen gas").beginStructureBlock(3, 3, 5, false).addController("Front center").addCasingInfoMin("Robust Tungstensteel Machine Casing", 12, false).addOtherStructurePart("GDC Ceramic Electrolyte Unit", "3x, Center 1x1x3").addOtherStructurePart("Reinforced Glass", "6x, touching the electrolyte units on the horizontal sides").addDynamoHatch("Back center", 2).addMaintenanceHatch("Any casing", 1).addInputHatch("Fuel, any casing", 1).addInputHatch("Oxygen, any casing", 1).addOutputHatch("Superheated Steam, any casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(48)};
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        ArrayList<FluidStack> storedFluids = super.getStoredFluids();
        Collection<GTRecipe> recipeList = RecipeMaps.gasTurbineFuels.getAllRecipes();
        for (FluidStack hatchFluid : storedFluids) {
            for (GTRecipe aFuel : recipeList) {
                FluidStack liquid = GTUtility.getFluidForFilledItem(aFuel.getRepresentativeInput(0), true);
                if (liquid == null || !hatchFluid.isFluidEqual(liquid)) continue;
                liquid.amount = (int)(491520.0f / ((float)aFuel.mSpecialValue * Math.max(1.0f, (float)aFuel.mSpecialValue / 1000.0f)));
                if (!super.depleteInput(liquid)) continue;
                if (!super.depleteInput(Materials.Oxygen.getGas(2000L))) {
                    this.mEUt = 0;
                    this.mEfficiency = 0;
                    return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                }
                this.mEUt = 24576;
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 200;
                if (this.mEfficiency == this.getMaxEfficiency(null)) {
                    super.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)96000));
                }
                return CheckRecipeResultRegistry.GENERATING;
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity thisController, ItemStack guiSlotItem) {
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 1, 0)) {
            return false;
        }
        return this.mCasing >= 12 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() >= 2;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean showRecipeTextInGUI() {
        return false;
    }
}

