/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.dataTransport;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DataPacket<T> {
    private static final byte MAX_HISTORY = 64;
    private final Set<Vec3Impl> trace = new LinkedHashSet<Vec3Impl>();
    protected T content;

    protected DataPacket(T content) {
        this.content = content;
    }

    protected DataPacket(NBTTagCompound nbt) {
        this.content = this.contentFromNBT(nbt.func_74775_l("qContent"));
        for (int i = 0; i < nbt.func_74771_c("qHistory"); ++i) {
            this.trace.add(new Vec3Impl(nbt.func_74762_e("qX" + i), nbt.func_74762_e("qY" + i), nbt.func_74762_e("qZ" + i)));
        }
    }

    public final NBTTagCompound toNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound contentTag = this.contentToNBT();
        if (contentTag != null) {
            nbt.func_74782_a("qContent", (NBTBase)contentTag);
        }
        nbt.func_74774_a("qHistory", (byte)this.trace.size());
        int i = 0;
        for (Vec3Impl v : this.trace) {
            nbt.func_74768_a("qX" + i, v.get0());
            nbt.func_74768_a("qY" + i, v.get1());
            nbt.func_74768_a("qZ" + i, v.get2());
            ++i;
        }
        return nbt;
    }

    protected abstract NBTTagCompound contentToNBT();

    protected abstract T contentFromNBT(NBTTagCompound var1);

    protected abstract T unifyContentWith(T var1);

    public final boolean contains(Vec3Impl v) {
        return this.trace.contains(v);
    }

    public final boolean check() {
        return this.trace.size() <= 64;
    }

    public abstract boolean extraCheck();

    protected final DataPacket<T> unifyTrace(Vec3Impl ... positions) {
        Collections.addAll(this.trace, positions);
        return this.check() && this.extraCheck() ? this : null;
    }

    protected final DataPacket<T> unifyTrace(DataPacket<T> p) {
        if (p == null) {
            return this;
        }
        this.trace.addAll(p.trace);
        return this.check() && this.extraCheck() ? this : null;
    }

    protected final DataPacket<T> unifyWith(DataPacket<T> p) {
        if (p == null) {
            return this;
        }
        this.trace.addAll(p.trace);
        if (this.check() && this.extraCheck()) {
            this.content = this.unifyContentWith(p.content);
            return this;
        }
        return null;
    }

    public final T contentIfNotInTrace(Vec3Impl pos) {
        if (this.trace.contains(pos)) {
            return null;
        }
        return this.getContent();
    }

    public T getContent() {
        return this.content;
    }

    public String getContentString() {
        return this.content.toString();
    }

    public final int getTraceSize() {
        return this.trace.size();
    }
}

