/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.util.data;

import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import com.gtnewhorizon.gtnhlib.util.data.BlockSupplier;
import com.gtnewhorizon.gtnhlib.util.data.IMod;
import com.gtnewhorizon.gtnhlib.util.data.ImmutableBlockMeta;
import com.gtnewhorizon.gtnhlib.util.data.Lazy;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;

public class LazyBlock
extends Lazy<ImmutableBlockMeta>
implements ImmutableBlockMeta {
    private final IMod mod;

    public LazyBlock(IMod mod, String blockName, int meta) {
        super(() -> {
            if (!mod.isModLoaded()) {
                throw new IllegalStateException("cannot get() LazyBlock " + mod.getID() + ":" + blockName + " because its mod is not loaded");
            }
            Block block = GameRegistry.findBlock((String)mod.getID(), (String)blockName);
            Objects.requireNonNull(block, "could not find block: " + mod.getID() + ":" + blockName);
            return new BlockMeta(block, meta);
        });
        this.mod = mod;
    }

    public LazyBlock(IMod mod, String blockName) {
        this(mod, blockName, 0);
    }

    public LazyBlock(IMod mod, BlockSupplier getter, int meta) {
        super(() -> {
            if (!mod.isModLoaded()) {
                return null;
            }
            Block block = (Block)getter.get();
            if (block == null) {
                return null;
            }
            return new BlockMeta(block, meta);
        });
        this.mod = mod;
    }

    public LazyBlock(IMod mod, BlockSupplier getter) {
        this(mod, getter, 0);
    }

    public boolean isPresent() {
        return this.mod.isModLoaded();
    }

    public IMod getMod() {
        return this.mod;
    }

    @Override
    @Nonnull
    public Block getBlock() {
        return ((ImmutableBlockMeta)this.get()).getBlock();
    }

    @Override
    public int getBlockMeta() {
        return ((ImmutableBlockMeta)this.get()).getBlockMeta();
    }

    @Override
    public boolean matches(Block other, int metaOther) {
        if (!this.isPresent()) {
            return false;
        }
        ImmutableBlockMeta bm = (ImmutableBlockMeta)this.get();
        return bm == null ? false : bm.matches(other, metaOther);
    }
}

