/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import com.pam.harvestcraft.ItemRegistry;
import com.pam.harvestcraft.PamUtils;
import com.pam.harvestcraft.base.item.ItemMincedMeat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GrinderRecipes {
    private static final GrinderRecipes grindingBase = new GrinderRecipes();
    private final Map<ItemStack, ItemStack[]> grindingList = new HashMap<ItemStack, ItemStack[]>();

    private GrinderRecipes() {
        for (int meta = 0; meta < ItemMincedMeat.meatTypes.length; ++meta) {
            ArrayList rawEntries = OreDictionary.getOres((String)("listAll" + ItemMincedMeat.meatTypes[meta] + "raw"));
            for (ItemStack oreEntry : rawEntries) {
                Item input = oreEntry.func_77973_b();
                if (input instanceof ItemMincedMeat) continue;
                this.registerItemRecipe(input, new ItemStack(ItemRegistry.mincedmeatrawItem, 1, meta), new ItemStack(ItemRegistry.mincedmeatrawItem, 1, meta));
            }
        }
    }

    public static GrinderRecipes grinding() {
        return grindingBase;
    }

    public void registerBlockRecipe(Block input, ItemStack output1, ItemStack output2) {
        this.registerItemRecipe(Item.func_150898_a((Block)input), output1, output2);
    }

    public void registerItemRecipe(Item input, ItemStack output1, ItemStack output2) {
        this.makeItemStackRecipe(new ItemStack(input, 1, Short.MAX_VALUE), output1, output2);
    }

    public void makeItemStackRecipe(ItemStack input, ItemStack output1, ItemStack output2) {
        ItemStack[] stacks = new ItemStack[]{output1, output2};
        this.grindingList.put(input, stacks);
    }

    public ItemStack[] getGrinderResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack[]> entry : this.grindingList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<ItemStack, ItemStack[]> getGrindingList() {
        return this.grindingList;
    }
}

