/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.fml.transformers.optifine;

import com.mitchej123.hodgepodge.core.shared.HodgepodgeClassDump;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class GLErrorLoggingTransformer
implements IClassTransformer,
Opcodes {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if ("shadersmod.client.Shaders".equals(transformedName)) {
            byte[] transformedBytes = GLErrorLoggingTransformer.transformBytes(basicClass);
            HodgepodgeClassDump.dumpClass(transformedName, basicClass, transformedBytes, this);
            return transformedBytes;
        }
        return basicClass;
    }

    private static byte[] transformBytes(byte[] basicClass) {
        Logger logger = LogManager.getLogger((String)"GLErrorLogging");
        logger.debug("TRANSFORMING shadersmod.client.Shaders");
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        block10: for (MethodNode mn : cn.methods) {
            int maxlocals;
            if (!mn.name.equals("checkGLError")) continue;
            switch (mn.desc) {
                case "(Ljava/lang/String;)I": {
                    maxlocals = 1;
                    break;
                }
                case "(Ljava/lang/String;Ljava/lang/String;)I": {
                    maxlocals = 2;
                    break;
                }
                case "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I": {
                    maxlocals = 3;
                    break;
                }
                default: {
                    break block10;
                }
            }
            logger.debug("Removing GL Error Logging: " + mn.desc);
            mn.visitMaxs(1, maxlocals);
            InsnList list = mn.instructions;
            list.clear();
            LabelNode l0 = new LabelNode();
            LabelNode l1 = new LabelNode();
            list.add((AbstractInsnNode)l0);
            list.add((AbstractInsnNode)new MethodInsnNode(184, "org/lwjgl/opengl/GL11", "glGetError", "()I", false));
            list.add((AbstractInsnNode)new InsnNode(172));
            list.add((AbstractInsnNode)l1);
            Iterator it = mn.localVariables.iterator();
            while (it.hasNext()) {
                LocalVariableNode lv = (LocalVariableNode)it.next();
                if (lv.desc.equals("Ljava/lang/String;")) {
                    lv.start = l0;
                    lv.end = l1;
                    continue;
                }
                it.remove();
            }
        }
        ClassWriter cw = new ClassWriter(0);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

