/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.shared;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EarlyConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"HodgepodgeEarly");
    public static final boolean noNukeBaseMod;
    public static final boolean noLeanerForgeConfiguration;
    public static final boolean debugLogConfigParsingTimes;
    public static final boolean dumpASMClass;

    public static void ensureLoaded() {
    }

    static {
        Properties config = new Properties();
        File configLocation = new File(Launch.minecraftHome, "config/hodgepodgeEarly.properties");
        if (configLocation.exists()) {
            try (BufferedReader r = new BufferedReader(new FileReader(configLocation));){
                config.load(r);
            }
            catch (IOException e) {
                LOGGER.error("Error reading configuration file. Will use defaults", (Throwable)e);
            }
        } else {
            LOGGER.debug("No existing configuration file. Will use defaults");
        }
        noNukeBaseMod = Boolean.parseBoolean(config.getProperty("noNukeBaseMod"));
        config.setProperty("noNukeBaseMod", String.valueOf(noNukeBaseMod));
        noLeanerForgeConfiguration = Boolean.parseBoolean(config.getProperty("noLeanerForgeConfiguration"));
        config.setProperty("noLeanerForgeConfiguration", String.valueOf(noLeanerForgeConfiguration));
        debugLogConfigParsingTimes = Boolean.getBoolean("hodgepodge.logConfigTimes");
        dumpASMClass = Boolean.getBoolean("hodgepodge.dumpClass");
        Path configDir = configLocation.toPath().getParent();
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectory(configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("Error creating configuration directory", (Throwable)e);
            }
        }
        try (BufferedWriter r = new BufferedWriter(new FileWriter(configLocation));){
            config.store(r, "Configuration file for early hodgepodge class transformers");
        }
        catch (IOException e) {
            LOGGER.error("Error writing configuration file. Will use defaults", (Throwable)e);
        }
    }
}

