/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.shared;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import net.minecraft.launchwrapper.Launch;

public final class FileLogger
implements AutoCloseable {
    private final SimpleDateFormat dateFormat;
    private PrintStream printStream = null;

    public FileLogger(String filename) {
        this(Launch.minecraftHome, filename);
    }

    public FileLogger(File logFolder, String filename) {
        this(logFolder, filename, null);
    }

    public FileLogger(File logFolder, String filename, String timeFormat) {
        if (filename == null) {
            throw new IllegalStateException("FileLogger file name cannot be null!");
        }
        this.dateFormat = timeFormat == null ? null : new SimpleDateFormat(timeFormat);
        if (logFolder == null) {
            logFolder = new File("");
        }
        logFolder.mkdirs();
        File logFile = new File(logFolder, FileLogger.getFilename(filename));
        if (logFile.exists()) {
            logFile.delete();
        }
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.printStream = new PrintStream(new FileOutputStream(logFile, true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static String getFilename(String filename) {
        String clName = FileLogger.stripClassName(FileLogger.class.getClassLoader().getClass().getName());
        if ("LaunchClassLoader".equals(clName)) {
            return filename;
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex >= 0) {
            return filename.substring(0, dotIndex) + '_' + clName + filename.substring(dotIndex);
        }
        return filename;
    }

    private static String stripClassName(String classname) {
        String[] split = classname.split("\\.");
        return split[split.length - 1];
    }

    public void log(String message) {
        if (this.printStream == null) {
            return;
        }
        if (this.dateFormat == null) {
            this.printStream.println(message);
            return;
        }
        String time = this.dateFormat.format(System.currentTimeMillis());
        this.printStream.println("[" + time + "] " + message);
    }

    public void printStackTrace() {
        if (this.printStream == null) {
            return;
        }
        new Exception().printStackTrace(this.printStream);
    }

    @Override
    public void close() {
        if (this.printStream == null) {
            return;
        }
        this.printStream.close();
    }
}

