/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod.vanilla;

import journeymap.client.cartography.RGB;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.log.JMLogger;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.mod.ModBlockDelegate;
import journeymap.common.Journeymap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class VanillaColorHandler
implements ModBlockDelegate.IModBlockColorHandler {
    public static final VanillaColorHandler INSTANCE = new VanillaColorHandler();
    private final IForgeHelper forgeHelper = ForgeHelper.INSTANCE;
    private final IColorHelper colorHelper = this.forgeHelper.getColorHelper();

    @Override
    public Integer getTextureColor(BlockMD blockMD) {
        return this.colorHelper.getTextureColor(blockMD);
    }

    @Override
    public Integer getBlockColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        Integer color = this.getBaseColor(chunkMD, blockMD, globalX, y, globalZ);
        if (blockMD.isBiomeColored()) {
            color = this.getBiomeColor(chunkMD, blockMD, globalX, y, globalZ);
        }
        if (color == null) {
            color = this.colorHelper.getMapColor(blockMD);
        }
        return color;
    }

    protected Integer getBiomeColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        if (blockMD.isGrass()) {
            return this.getGrassColor(chunkMD, blockMD, globalX, y, globalZ);
        }
        if (blockMD.isFoliage()) {
            return this.getFoliageColor(chunkMD, blockMD, globalX, y, globalZ);
        }
        if (blockMD.isWater()) {
            return this.getWaterColor(chunkMD, blockMD, globalX, y, globalZ);
        }
        return this.getCustomBiomeColor(chunkMD, blockMD, globalX, y, globalZ);
    }

    protected int getBaseColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        Integer color = blockMD.getColor();
        if (color == null) {
            if (blockMD.isAir()) {
                color = -1;
                blockMD.setAlpha(0.0f);
                blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.OpenToSky, BlockMD.Flag.NoShadow);
            } else {
                color = this.loadTextureColor(blockMD, globalX, y, globalZ);
            }
            blockMD.setColor(color);
        }
        return color;
    }

    protected Integer getCustomBiomeColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        Integer color = this.getBaseColor(chunkMD, blockMD, globalX, y, globalZ);
        int tint = this.getTint(chunkMD, blockMD, globalX, y, globalZ);
        if (!RGB.isWhite(tint) && !RGB.isBlack(tint)) {
            color = RGB.multiply(color, tint);
            if (!blockMD.hasFlag(BlockMD.Flag.CustomBiomeColor)) {
                blockMD.addFlags(BlockMD.Flag.CustomBiomeColor);
                Journeymap.getLogger().info("Custom biome tint set for " + blockMD);
            }
        } else {
            Journeymap.getLogger().debug("Custom biome tint not found for " + blockMD);
        }
        return color;
    }

    protected Integer getFoliageColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        return RGB.adjustBrightness(RGB.multiply(this.getBaseColor(chunkMD, blockMD, globalX, y, globalZ), this.getTint(chunkMD, blockMD, globalX, y, globalZ)), 0.8f);
    }

    protected Integer getGrassColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        return RGB.multiply(0x929292, this.getTint(chunkMD, blockMD, globalX, y, globalZ));
    }

    protected Integer getWaterColor(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        return RGB.multiply(this.getBaseColor(chunkMD, blockMD, globalX, y, globalZ), this.getTint(chunkMD, blockMD, globalX, y, globalZ));
    }

    protected Integer getTint(ChunkMD chunkMD, BlockMD blockMD, int globalX, int y, int globalZ) {
        try {
            return this.colorHelper.getColorMultiplier(chunkMD, blockMD.getBlock(), globalX, y, globalZ);
        }
        catch (Exception e) {
            JMLogger.logOnce("Block throws exception when calling colorMultiplier(): " + blockMD.getBlock().func_149739_a(), e);
            return -1;
        }
    }

    protected Integer loadTextureColor(BlockMD blockMD, int globalX, int y, int globalZ) {
        Integer baseColor = null;
        baseColor = this.getTextureColor(blockMD);
        if (baseColor != null && !blockMD.isBiomeColored()) {
            int tint = this.getTint(null, blockMD, globalX, y, globalZ);
            if (!RGB.isWhite(tint) && !RGB.isBlack(tint)) {
                blockMD.addFlags(BlockMD.Flag.CustomBiomeColor);
                Journeymap.getLogger().info("Custom biome color will be used with " + blockMD);
            } else {
                int renderColor = this.colorHelper.getRenderColor(blockMD);
                if (!RGB.isWhite(renderColor)) {
                    baseColor = RGB.multiply(baseColor, 0xFF000000 | renderColor);
                    Journeymap.getLogger().info("Applied render color for " + blockMD);
                }
            }
        }
        if (baseColor == null) {
            baseColor = -16777216;
            if (blockMD.hasFlag(BlockMD.Flag.TileEntity)) {
                Journeymap.getLogger().info("Iconloader ignoring tile entity: " + blockMD);
            } else if (this.colorHelper.failedFor(blockMD)) {
                Journeymap.getLogger().warn("Iconloader failed to get base color for " + blockMD);
            } else {
                Journeymap.getLogger().warn("Unknown failure, could not get base color for " + blockMD);
            }
        }
        return baseColor;
    }

    public void setExplicitColors() {
        BlockMD.VOIDBLOCK.setColor(1117209);
        BlockMD.get((Block)Blocks.field_150328_O, 0).setColor(9962502);
        BlockMD.get((Block)Blocks.field_150328_O, 1).setColor(1998518);
        BlockMD.get((Block)Blocks.field_150328_O, 2).setColor(8735158);
        BlockMD.get((Block)Blocks.field_150328_O, 3).setColor(10330535);
        BlockMD.get((Block)Blocks.field_150328_O, 4).setColor(9962502);
        BlockMD.get((Block)Blocks.field_150328_O, 5).setColor(10704922);
        BlockMD.get((Block)Blocks.field_150328_O, 6).setColor(0xB0B0B0);
        BlockMD.get((Block)Blocks.field_150328_O, 7).setColor(11573936);
        BlockMD.get((Block)Blocks.field_150328_O, 8).setColor(0xB3B3B3);
        BlockMD.get((Block)Blocks.field_150327_N, 0).setColor(11514881);
    }
}

