/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.client.avatar.AvatarItemStack;
import com.creativemd.creativecore.common.gui.controls.GuiAvatarLabel;
import com.creativemd.creativecore.common.gui.controls.GuiListBox;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiItemListBox
extends GuiListBox {
    public ArrayList<ItemStack> stacks;

    public GuiItemListBox(String name, EntityPlayer player, int x, int y, int width, int height, ArrayList<ItemStack> stacks, ArrayList<String> lines) {
        super(name, player, x, y, width, height, lines);
        this.stacks = stacks;
        this.refreshControls();
    }

    @Override
    public void clear() {
        this.stacks.clear();
        super.clear();
        this.refreshControls();
    }

    public void add(String input, ItemStack stack) {
        this.stacks.add(stack);
        this.lines.add(input);
        this.refreshControls();
    }

    public ItemStack getSelectedStack() {
        if (this.selected >= 0 && this.selected < this.stacks.size()) {
            return this.stacks.get(this.selected);
        }
        return null;
    }

    @Override
    public void refreshControls() {
        this.gui.controls.clear();
        if (this.stacks != null && this.stacks.size() == this.lines.size()) {
            for (int i = 0; i < this.lines.size(); ++i) {
                int color = 0xE0E0E0;
                if (i == this.selected) {
                    color = 0xFFFF28;
                }
                GuiAvatarLabel label = new GuiAvatarLabel((String)this.lines.get(i), 3, 1 + i * 20, color, new AvatarItemStack(this.stacks.get(i)));
                label.width = this.width - 20;
                label.height = 20;
                this.addControl(label);
            }
        }
    }
}

