/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.Rotation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class RotationUtils {
    public static boolean isNegative(ForgeDirection direction) {
        return direction == ForgeDirection.WEST || direction == ForgeDirection.DOWN || direction == ForgeDirection.NORTH;
    }

    public static void applyDirection(ForgeDirection direction, ChunkCoordinates coord) {
        switch (direction) {
            case DOWN: {
                --coord.field_71572_b;
                break;
            }
            case EAST: {
                ++coord.field_71574_a;
                break;
            }
            case NORTH: {
                --coord.field_71573_c;
                break;
            }
            case SOUTH: {
                ++coord.field_71573_c;
                break;
            }
            case UP: {
                ++coord.field_71572_b;
                break;
            }
            case WEST: {
                --coord.field_71574_a;
                break;
            }
        }
    }

    public static int getIndex(ForgeDirection direction) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (ForgeDirection.VALID_DIRECTIONS[i] != direction) continue;
            return i;
        }
        return -1;
    }

    public static Vec3 applyVectorRotation(Vec3 vector, ForgeDirection direction) {
        return RotationUtils.applyVectorRotation(vector, Rotation.getRotationByDirection(direction));
    }

    public static Vec3 applyVectorRotation(Vec3 vector, Rotation direction) {
        double tempX = vector.field_72450_a;
        double tempY = vector.field_72448_b;
        double tempZ = vector.field_72449_c;
        switch (direction) {
            case UP: {
                vector.field_72450_a = -tempY;
                vector.field_72448_b = tempX;
                break;
            }
            case DOWN: {
                vector.field_72450_a = tempY;
                vector.field_72448_b = -tempX;
                break;
            }
            case UPX: {
                vector.field_72449_c = -tempY;
                vector.field_72448_b = tempZ;
                break;
            }
            case DOWNX: {
                vector.field_72449_c = tempY;
                vector.field_72448_b = -tempZ;
                break;
            }
            case SOUTH: {
                vector.field_72450_a = -tempZ;
                vector.field_72449_c = tempX;
                break;
            }
            case NORTH: {
                vector.field_72450_a = tempZ;
                vector.field_72449_c = -tempX;
                break;
            }
            case WEST: {
                vector.field_72450_a = -tempX;
                vector.field_72449_c = -tempZ;
                break;
            }
        }
        return vector;
    }

    public static void applyCubeRotation(CubeObject cube, ForgeDirection direction) {
        RotationUtils.applyCubeRotation(cube, Rotation.getRotationByDirection(direction), Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5));
    }

    public static void applyCubeRotation(CubeObject cube, Rotation direction, Vec3 center) {
        double minX = cube.minX;
        double minY = cube.minY;
        double minZ = cube.minZ;
        double maxX = cube.maxX;
        double maxY = cube.maxY;
        double maxZ = cube.maxZ;
        if (center != null) {
            minX -= center.field_72450_a;
            minY -= center.field_72448_b;
            minZ -= center.field_72449_c;
            maxX -= center.field_72450_a;
            maxY -= center.field_72448_b;
            maxZ -= center.field_72449_c;
        }
        Vec3 min = RotationUtils.applyVectorRotation(Vec3.func_72443_a((double)minX, (double)minY, (double)minZ), direction);
        Vec3 max = RotationUtils.applyVectorRotation(Vec3.func_72443_a((double)maxX, (double)maxY, (double)maxZ), direction);
        if (center != null) {
            min = min.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            max = max.func_72441_c(center.field_72450_a, center.field_72448_b, center.field_72449_c);
        }
        if (min.field_72450_a < max.field_72450_a) {
            cube.minX = min.field_72450_a;
            cube.maxX = max.field_72450_a;
        } else {
            cube.minX = max.field_72450_a;
            cube.maxX = min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            cube.minY = min.field_72448_b;
            cube.maxY = max.field_72448_b;
        } else {
            cube.minY = max.field_72448_b;
            cube.maxY = min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            cube.minZ = min.field_72449_c;
            cube.maxZ = max.field_72449_c;
        } else {
            cube.minZ = max.field_72449_c;
            cube.maxZ = min.field_72449_c;
        }
    }

    public static ForgeDirection getDirectionFromVec(Vec3 vec) {
        if (vec.field_72450_a == 1.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 0.0) {
            return ForgeDirection.EAST;
        }
        if (vec.field_72450_a == -1.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 0.0) {
            return ForgeDirection.WEST;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == 1.0 && vec.field_72449_c == 0.0) {
            return ForgeDirection.UP;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == -1.0 && vec.field_72449_c == 0.0) {
            return ForgeDirection.DOWN;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 1.0) {
            return ForgeDirection.SOUTH;
        }
        if (vec.field_72450_a == 0.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == -1.0) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection rotateForgeDirection(ForgeDirection direction, ForgeDirection direction2) {
        Vec3 vec = Vec3.func_72443_a((double)direction.offsetX, (double)direction.offsetY, (double)direction.offsetZ);
        return RotationUtils.getDirectionFromVec(RotationUtils.applyVectorRotation(vec, direction2));
    }

    public static enum Axis {
        Xaxis,
        Yaxis,
        Zaxis;


        public boolean isAxis(ForgeDirection direction) {
            switch (this) {
                case Xaxis: {
                    return direction == ForgeDirection.EAST || direction == ForgeDirection.WEST;
                }
                case Yaxis: {
                    return direction == ForgeDirection.UP || direction == ForgeDirection.DOWN;
                }
                case Zaxis: {
                    return direction == ForgeDirection.SOUTH || direction == ForgeDirection.NORTH;
                }
            }
            return false;
        }

        public int toInt() {
            switch (this) {
                case Xaxis: {
                    return 0;
                }
                case Yaxis: {
                    return 1;
                }
                case Zaxis: {
                    return 2;
                }
            }
            return 0;
        }

        public ForgeDirection getDirection() {
            switch (this) {
                case Xaxis: {
                    return ForgeDirection.EAST;
                }
                case Yaxis: {
                    return ForgeDirection.UP;
                }
                case Zaxis: {
                    return ForgeDirection.SOUTH;
                }
            }
            return ForgeDirection.UNKNOWN;
        }

        public static Axis getAxis(ForgeDirection direction) {
            if (direction == ForgeDirection.EAST || direction == ForgeDirection.WEST) {
                return Xaxis;
            }
            if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
                return Yaxis;
            }
            if (direction == ForgeDirection.SOUTH || direction == ForgeDirection.NORTH) {
                return Zaxis;
            }
            return null;
        }

        public static Axis getAxis(int id) {
            if (id == 0) {
                return Xaxis;
            }
            if (id == 1) {
                return Yaxis;
            }
            if (id == 2) {
                return Zaxis;
            }
            return null;
        }
    }
}

