/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.string;

import com.creativemd.creativecore.common.utils.string.StringConverter;
import com.creativemd.creativecore.common.utils.string.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import org.apache.commons.lang3.ArrayUtils;

public class ConvertNBTTagCompound
extends StringConverter {
    public ConvertNBTTagCompound() {
        super("NBTTagCompound");
    }

    @Override
    public Class getClassOfObject() {
        return NBTTagCompound.class;
    }

    public static Object getObject(NBTBase base) {
        if (base instanceof NBTTagByte) {
            return ((NBTTagByte)base).func_150290_f();
        }
        if (base instanceof NBTTagShort) {
            return ((NBTTagShort)base).func_150289_e();
        }
        if (base instanceof NBTTagInt) {
            return ((NBTTagInt)base).func_150287_d();
        }
        if (base instanceof NBTTagLong) {
            return ((NBTTagLong)base).func_150291_c();
        }
        if (base instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)base).func_150288_h());
        }
        if (base instanceof NBTTagDouble) {
            return ((NBTTagDouble)base).func_150286_g();
        }
        if (base instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)base).func_150292_c();
        }
        if (base instanceof NBTTagString) {
            return ((NBTTagString)base).func_150285_a_();
        }
        if (base instanceof NBTTagList) {
            return base;
        }
        if (base instanceof NBTTagCompound) {
            return (NBTTagCompound)base;
        }
        if (base instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)base).func_150302_c();
        }
        return null;
    }

    @Override
    public String toString(Object object) {
        NBTTagCompound nbt = (NBTTagCompound)object;
        Set tags = nbt.func_150296_c();
        Iterator iterator = tags.iterator();
        ArrayList<Object> objects = new ArrayList<Object>();
        int i = 0;
        while (iterator.hasNext()) {
            Object ObjectString = iterator.next();
            if (!(ObjectString instanceof String)) continue;
            String name = (String)ObjectString;
            NBTBase base = nbt.func_74781_a(name);
            Object data = ConvertNBTTagCompound.getObject(base);
            if (data == null) {
                System.out.println("Found invalid NBT Data (END is unspported)");
            } else {
                objects.add(name);
                objects.add(data);
            }
            ++i;
        }
        return StringUtils.ObjectsToString(objects.toArray());
    }

    @Override
    public Object parseObject(String input) {
        Object[] objects = StringUtils.StringToObjects(input);
        NBTTagCompound nbt = new NBTTagCompound();
        for (int i = 0; i < objects.length / 2; ++i) {
            int index = i * 2;
            String name = (String)objects[index];
            Object object = objects[index + 1];
            if (object instanceof Byte[]) {
                nbt.func_74773_a(name, ArrayUtils.toPrimitive((Byte[])((Byte[])object)));
                continue;
            }
            if (object instanceof byte[]) {
                nbt.func_74773_a(name, (byte[])object);
                continue;
            }
            if (object instanceof Integer[]) {
                nbt.func_74783_a(name, ArrayUtils.toPrimitive((Integer[])((Integer[])object)));
                continue;
            }
            if (object instanceof int[]) {
                nbt.func_74783_a(name, (int[])object);
                continue;
            }
            if (object instanceof Byte) {
                nbt.func_74774_a(name, ((Byte)object).byteValue());
                continue;
            }
            if (object instanceof Short) {
                nbt.func_74777_a(name, ((Short)object).shortValue());
                continue;
            }
            if (object instanceof Integer) {
                nbt.func_74768_a(name, ((Integer)object).intValue());
                continue;
            }
            if (object instanceof Long) {
                nbt.func_74772_a(name, ((Long)object).longValue());
                continue;
            }
            if (object instanceof Float) {
                nbt.func_74776_a(name, ((Float)object).floatValue());
                continue;
            }
            if (object instanceof Double) {
                nbt.func_74780_a(name, ((Double)object).doubleValue());
                continue;
            }
            if (object instanceof String) {
                nbt.func_74778_a(name, (String)object);
                continue;
            }
            if (object instanceof NBTTagCompound) {
                nbt.func_74782_a(name, (NBTBase)((NBTTagCompound)object));
                continue;
            }
            if (object instanceof NBTTagList) {
                nbt.func_74782_a(name, (NBTBase)((NBTTagList)object));
                continue;
            }
            System.out.println("Couldn't add object to nbttag name=" + name + " class=" + object.getClass().getName());
        }
        return nbt;
    }

    @Override
    public String[] getSplitter() {
        return new String[0];
    }
}

