/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.pipe;

import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.GuiPipeController;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgrade;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.gui.DummyContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class PipeController
extends CoordinatesGuiProvider {
    public PipeController(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_());
        if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        return new GuiPipeController(player, (CoreRoutedPipe)pipe.pipe);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        int pipeSlot;
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_());
        if (tile == null || !(tile.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        final CoreRoutedPipe pipe = (CoreRoutedPipe)tile.pipe;
        DummyContainer dummy = new DummyContainer(player, null, pipe.getOriginalUpgradeManager().getGuiController(), new IGuiOpenControler(){

            @Override
            public void guiOpenedByPlayer(EntityPlayer player) {
                pipe.playerStartWatching(player, 0);
            }

            @Override
            public void guiClosedByPlayer(EntityPlayer player) {
                pipe.playerStopWatching(player, 0);
            }
        });
        dummy.addNormalSlotsForPlayerInventory(0, 0);
        for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (IInventory)pipe.getOriginalUpgradeManager().getInv(), 8 + pipeSlot * 18, 18, itemStack -> {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() == LogisticsPipes.UpgradeItem) {
                    return LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null).isAllowedForPipe(pipe);
                }
                return false;
            });
        }
        for (pipeSlot = 0; pipeSlot < 9; ++pipeSlot) {
            dummy.addRestrictedSlot(pipeSlot, (IInventory)pipe.getOriginalUpgradeManager().getSneakyInv(), 8 + pipeSlot * 18, 48, itemStack -> {
                if (itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() == LogisticsPipes.UpgradeItem) {
                    IPipeUpgrade upgrade = LogisticsPipes.UpgradeItem.getUpgradeForItem(itemStack, null);
                    if (!(upgrade instanceof SneakyUpgrade)) {
                        return false;
                    }
                    return upgrade.isAllowedForPipe(pipe);
                }
                return false;
            });
        }
        dummy.addStaticRestrictedSlot(0, (IInventory)pipe.getOriginalUpgradeManager().getSecInv(), 152, 18, itemStack -> {
            if (itemStack == null) {
                return false;
            }
            if (itemStack.func_77973_b() != LogisticsPipes.LogisticsItemCard) {
                return false;
            }
            if (itemStack.func_77960_j() != 1) {
                return false;
            }
            return SimpleServiceLocator.securityStationManager.isAuthorized(UUID.fromString(itemStack.func_77978_p().func_74779_i("UUID")));
        }, 1);
        dummy.addRestrictedSlot(0, (IInventory)tile.logicController.diskInv, 14, 36, LogisticsPipes.LogisticsItemDisk);
        return dummy;
    }

    @Override
    public GuiProvider template() {
        return new PipeController(this.getId());
    }
}

