/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import logisticspipes.network.abstractpackets.IntegerCoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.RequestHandler;
import net.minecraft.entity.player.EntityPlayer;

public class OrdererRefreshRequestPacket
extends IntegerCoordinatesPacket {
    public OrdererRefreshRequestPacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new OrdererRefreshRequestPacket(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        RequestHandler.DisplayOptions option;
        int dimension = (this.getInteger() - this.getInteger() % 10) / 10;
        LogisticsTileGenericPipe pipe = MainProxy.proxy.getPipeInDimensionAt(dimension, this.getPosX(), this.getPosY(), this.getPosZ(), player);
        if (pipe == null || !(pipe.pipe instanceof CoreRoutedPipe)) {
            return;
        }
        switch (this.getInteger() % 10) {
            case 1: {
                option = RequestHandler.DisplayOptions.SupplyOnly;
                break;
            }
            case 2: {
                option = RequestHandler.DisplayOptions.CraftOnly;
                break;
            }
            default: {
                option = RequestHandler.DisplayOptions.Both;
            }
        }
        RequestHandler.refresh(player, (CoreRoutedPipe)pipe.pipe, option);
    }
}

