/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.gui.popup.GuiRecipeImport;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.MostLikelyRecipeComponentsResponse;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class FindMostLikelyRecipeComponents
extends CoordinatesPacket {
    private List<GuiRecipeImport.Canidates> content;

    public FindMostLikelyRecipeComponents(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity tile = this.getTile(player.func_130014_f_(), TileEntity.class);
        CoreRoutedPipe pipe = null;
        if (tile instanceof LogisticsCraftingTableTileEntity) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity conn = ((LogisticsCraftingTableTileEntity)tile).getLPPosition().moveForward(dir).getTileEntity(player.func_130014_f_());
                if (!(conn instanceof LogisticsTileGenericPipe) || !(((LogisticsTileGenericPipe)conn).pipe instanceof PipeItemsCraftingLogistics)) continue;
                pipe = (CoreRoutedPipe)((LogisticsTileGenericPipe)conn).pipe;
                break;
            }
        } else if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            pipe = (CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(this.content.size());
        while (list.size() < this.content.size()) {
            list.add(-1);
        }
        if (pipe == null) {
            return;
        }
        LinkedList<ItemIdentifier> craftable = null;
        for (int j = 0; j < this.content.size(); ++j) {
            GuiRecipeImport.Canidates canidates = this.content.get(j);
            int maxItemPos = -1;
            int max = 0;
            for (int i = 0; i < canidates.order.size(); ++i) {
                ItemIdentifier ident = canidates.order.get(i).getItem();
                int newAmount = SimpleServiceLocator.logisticsManager.getAmountFor(ident, pipe.getRouter().getIRoutersByCost());
                if (newAmount <= max) continue;
                max = newAmount;
                maxItemPos = i;
            }
            if (max < 64) {
                if (craftable == null) {
                    craftable = SimpleServiceLocator.logisticsManager.getCraftableItems(pipe.getRouter().getIRoutersByCost());
                }
                block4: for (ItemIdentifier craft : craftable) {
                    for (int i = 0; i < canidates.order.size(); ++i) {
                        ItemIdentifier ident = canidates.order.get(i).getItem();
                        if (craft != ident) continue;
                        maxItemPos = i;
                        continue block4;
                    }
                }
            }
            list.set(j, maxItemPos);
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(MostLikelyRecipeComponentsResponse.class).setResponse(list), player);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        this.content = data.readList(data12 -> {
            GuiRecipeImport.Canidates can = new GuiRecipeImport.Canidates(new TreeSet<ItemIdentifierStack>());
            can.order = data12.readList(LPDataInputStream::readItemIdentifierStack);
            return can;
        });
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeList(this.content, (data12, object) -> data12.writeList(object.order, LPDataOutputStream::writeItemIdentifierStack));
    }

    @Override
    public ModernPacket template() {
        return new FindMostLikelyRecipeComponents(this.getId());
    }

    public List<GuiRecipeImport.Canidates> getContent() {
        return this.content;
    }

    public FindMostLikelyRecipeComponents setContent(List<GuiRecipeImport.Canidates> content) {
        this.content = content;
        return this;
    }
}

