/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.opencomputers.asm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractValue;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCDirectCall;
import logisticspipes.proxy.computers.interfaces.CCQueued;
import logisticspipes.proxy.computers.interfaces.ICCTypeWrapped;
import logisticspipes.proxy.computers.objects.CCItemIdentifier;
import logisticspipes.proxy.computers.objects.CCItemIdentifierBuilder;
import logisticspipes.proxy.computers.objects.CCItemIdentifierStack;
import logisticspipes.proxy.computers.objects.LPGlobalCCAccess;
import logisticspipes.proxy.computers.wrapper.CCObjectWrapper;
import logisticspipes.proxy.computers.wrapper.CCWrapperInformation;
import logisticspipes.proxy.computers.wrapper.ICommandWrapper;
import logisticspipes.proxy.opencomputers.asm.ClassCreator;
import logisticspipes.security.PermissionException;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public abstract class BaseWrapperClass
extends AbstractValue {
    public static final ICommandWrapper WRAPPER = new ICommandWrapper(){
        private final Map<Class<?>, Class<? extends BaseWrapperClass>> map = new HashMap();

        @Override
        public Object getWrappedObject(CCWrapperInformation info, Object object) {
            try {
                Class<? extends BaseWrapperClass> clazz = this.map.get(object.getClass());
                if (clazz == null) {
                    clazz = ClassCreator.getWrapperClass(info, object.getClass().getName());
                    this.map.put(object.getClass(), clazz);
                }
                return clazz.getConstructor(CCWrapperInformation.class, Object.class).newInstance(info, object);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    };
    private final CCWrapperInformation info;
    private Object object;
    public boolean isDirectCall;

    public BaseWrapperClass(String wrappedClass) throws ClassNotFoundException {
        this(CCObjectWrapper.getWrapperInformation(Class.forName(wrappedClass)), null);
    }

    public BaseWrapperClass(CCWrapperInformation info, Object object) {
        this.info = info;
        this.object = object;
    }

    @Callback(direct=true)
    public Object[] help(Context context, Arguments args) throws Exception {
        if (this.object == null) {
            throw new Exception("This LP object is not persistable");
        }
        StringBuilder help = new StringBuilder();
        StringBuilder head = new StringBuilder();
        StringBuilder head2 = new StringBuilder();
        head.append("Type: ");
        head.append(this.info.type);
        head.append("\n");
        head2.append("Commands: \n");
        for (Integer num : this.info.commands.keySet()) {
            int number;
            Method method = this.info.commands.get(num);
            StringBuilder command = new StringBuilder();
            if (help.length() != 0) {
                command.append("\n");
            }
            if ((number = num.intValue()) < 10) {
                command.append(" ");
            }
            command.append(number);
            command.append(" ");
            if (method.isAnnotationPresent(CCDirectCall.class)) {
                command.append("D");
            } else {
                command.append(" ");
            }
            if (method.isAnnotationPresent(CCQueued.class)) {
                command.append("Q");
            } else {
                command.append(" ");
            }
            command.append(": ");
            command.append(method.getName());
            StringBuilder param = new StringBuilder();
            param.append("(");
            boolean a = false;
            for (Class<?> clazz : method.getParameterTypes()) {
                if (a) {
                    param.append(", ");
                }
                param.append(clazz.getSimpleName());
                a = true;
            }
            param.append(")");
            if (param.toString().length() + command.length() > 50) {
                command.append("\n      ---");
            }
            command.append((CharSequence)param);
            help.append((CharSequence)command);
        }
        String commands = help.toString();
        String[] lines = commands.split("\n");
        if (lines.length > 16) {
            int pageNumber = 1;
            if (args.count() > 0 && (args.isDouble(0) || args.isInteger(0)) && (pageNumber = args.checkInteger(0)) < 1) {
                pageNumber = 1;
            }
            StringBuilder page = new StringBuilder();
            page.append((CharSequence)head);
            page.append("Page ");
            page.append(pageNumber);
            page.append(" of ");
            page.append(lines.length / 10 + (lines.length % 10 == 0 ? 0 : 1));
            page.append("\n");
            page.append((CharSequence)head2);
            int from = --pageNumber * 11;
            int to = pageNumber * 11 + 11;
            for (int i = from; i < to; ++i) {
                if (i < lines.length) {
                    page.append(lines[i]);
                }
                if (i >= to - 1) continue;
                page.append("\n");
            }
            return new Object[]{page.toString()};
        }
        for (int i = 0; i < 16 - lines.length; ++i) {
            String buffer = head.toString();
            head = new StringBuilder();
            head.append("\n").append(buffer);
        }
        return new Object[]{String.valueOf(head) + head2 + help};
    }

    @Callback(direct=true)
    public Object[] helpCommand(Context context, Arguments args) throws Exception {
        if (this.object == null) {
            throw new Exception("This LP object is not persistable");
        }
        if (args.count() != 1) {
            return new Object[]{"Wrong Argument Count"};
        }
        if (!args.isInteger(0)) {
            return new Object[]{"Wrong Argument Type"};
        }
        Integer number = args.checkInteger(0);
        if (!this.info.commands.containsKey(number)) {
            return new Object[]{"No command with that index"};
        }
        Method method = this.info.commands.get(number);
        StringBuilder help = new StringBuilder();
        help.append("---------------------------------\n");
        help.append("Command: ");
        help.append(method.getName());
        help.append("\n");
        help.append("Parameter: ");
        if (method.getParameterCount() > 0) {
            help.append("\n");
            boolean a = false;
            for (Class<?> clazz : method.getParameterTypes()) {
                if (a) {
                    help.append(", ");
                }
                help.append(clazz.getSimpleName());
                a = true;
            }
            help.append("\n");
        } else {
            help.append("NONE\n");
        }
        help.append("Return Type: ");
        help.append(method.getReturnType().getName());
        help.append("\n");
        help.append("Description: \n");
        help.append(method.getAnnotation(CCCommand.class).description());
        return new Object[]{help.toString()};
    }

    public String toString() {
        block5: {
            if (this.object != null) {
                try {
                    if (this.object.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class) {
                        return this.getType() + ": " + this.object.toString();
                    }
                    if (this.object instanceof ICCTypeWrapped && ((ICCTypeWrapped)this.object).getObject().getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class) {
                        return this.getType() + ": " + ((ICCTypeWrapped)this.object).getObject().toString();
                    }
                }
                catch (NoSuchMethodException | SecurityException e) {
                    if (!LPConstants.DEBUG) break block5;
                    e.printStackTrace();
                }
            }
        }
        return this.getType();
    }

    public Object[] invokeMethod(String methodName, Context context, Arguments args) throws Exception {
        Object result;
        if (this.object == null) {
            throw new Exception("This LP object is not persistable");
        }
        int length = args.count();
        Object[] arguments = new Object[length];
        for (int i = 0; i < length; ++i) {
            if (args.isString(i)) {
                arguments[i] = args.checkString(i);
                continue;
            }
            Iterator<Method> tmp = args.checkAny(i);
            if (tmp instanceof BaseWrapperClass) {
                tmp = ((BaseWrapperClass)((Object)tmp)).getObject();
            }
            if (tmp instanceof ICCTypeWrapped) {
                tmp = ((ICCTypeWrapped)((Object)tmp)).getObject();
            }
            arguments[i] = tmp;
        }
        Method match = null;
        for (Method method : this.info.commands.values()) {
            if (!method.getName().equalsIgnoreCase(methodName) || !this.argumentsMatch(method, arguments)) continue;
            match = method;
            break;
        }
        if (match == null) {
            StringBuilder error = new StringBuilder();
            StringBuilder attemptedArgs = new StringBuilder();
            attemptedArgs.append("(");
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    attemptedArgs.append(", ");
                }
                attemptedArgs.append(arguments[i] != null ? arguments[i].getClass().getSimpleName() : "null");
            }
            attemptedArgs.append(")");
            error.append("Method '").append(methodName).append((CharSequence)attemptedArgs).append("' not found.");
            boolean foundMethodsWithSameName = false;
            for (Method method : this.info.commands.values()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                foundMethodsWithSameName = true;
                break;
            }
            if (foundMethodsWithSameName) {
                error.append("\n\nAvailable overloads for '").append(methodName).append("':");
                for (Method method : this.info.commands.values()) {
                    if (!method.getName().equalsIgnoreCase(methodName)) continue;
                    error.append("\n  - ").append(method.getName()).append("(");
                    boolean first = true;
                    for (Class<?> clazz : method.getParameterTypes()) {
                        if (!first) {
                            error.append(", ");
                        }
                        error.append(clazz.getSimpleName());
                        first = false;
                    }
                    error.append(")");
                }
                error.append("\n\nCheck parameter types and count.");
            } else {
                error.append("\n\nNo method named '").append(methodName).append("' exists.");
                error.append("\nUse help() to see all available methods.");
            }
            throw new UnsupportedOperationException(error.toString());
        }
        if (match.getAnnotation(CCDirectCall.class) != null && !this.isDirectCall) {
            throw new PermissionException();
        }
        if (match.getAnnotation(CCCommand.class).needPermission() && this.info.securityMethod != null) {
            try {
                this.info.securityMethod.invoke(this.object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Exception) {
                    throw (Exception)e.getTargetException();
                }
                throw e;
            }
        }
        try {
            if (this.info.setSourceMod != null) {
                this.info.setSourceMod.invoke(this.object, new Object[]{CCWrapperInformation.SourceMod.OPENCOMPUTERS});
            }
            result = match.invoke(this.object, arguments);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        return CCObjectWrapper.createArray(CCObjectWrapper.getWrappedObject(result, WRAPPER));
    }

    private boolean argumentsMatch(Method method, Object[] arguments) {
        if (arguments.length != method.getParameterCount()) {
            return false;
        }
        int i = 0;
        for (Class<?> args : method.getParameterTypes()) {
            if (arguments.length <= i) {
                return false;
            }
            if (!args.isAssignableFrom(arguments[i].getClass())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getType() {
        return this.info.type;
    }

    public Object getObject() {
        return this.object;
    }

    public void load(NBTTagCompound nbt) {
        if (this.object != null) {
            return;
        }
        String type = nbt.func_74779_i("Type");
        if (type.equals("")) {
            return;
        }
        if ("LPGlobalCCAccess".equals(type)) {
            this.object = LogisticsPipes.getComputerLP();
            this.checkType();
        } else if ("CoreRoutedPipe".equals(type)) {
            int x = nbt.func_74762_e("X");
            int y = nbt.func_74762_e("Y");
            int z = nbt.func_74762_e("Z");
            LPPosition pos = new LPPosition(x, y, z);
            int dim = nbt.func_74762_e("Dim");
            QueuedTasks.queueTask(() -> {
                TileEntity tile;
                WorldServer world = DimensionManager.getWorld((int)dim);
                if (world != null && (tile = pos.getTileEntity((World)world)) instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe) {
                    this.object = ((LogisticsTileGenericPipe)tile).pipe;
                    this.checkType();
                }
                return null;
            });
        } else if ("CCItemIdentifierImplementation".equals(type)) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            if (stack != null) {
                this.object = new CCItemIdentifier.CCItemIdentifierImplementation(ItemIdentifier.get(stack));
                this.checkType();
            }
        } else if ("CCItemIdentifierStackImplementation".equals(type)) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            if (stack != null) {
                this.object = new CCItemIdentifierStack.CCItemIdentifierStackImplementation(ItemIdentifierStack.getFromStack(stack));
                this.checkType();
            }
        } else if ("CCItemIdentifierBuilder".equals(type)) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            if (stack != null) {
                CCItemIdentifierBuilder builder = new CCItemIdentifierBuilder();
                builder.setItemID(Long.valueOf(Item.func_150891_b((Item)stack.func_77973_b())));
                builder.setItemData(Long.valueOf(stack.func_77960_j()));
                this.object = builder;
                this.checkType();
            }
        } else if ("LogisticsSolidTileEntity".equals(type)) {
            int x = nbt.func_74762_e("X");
            int y = nbt.func_74762_e("Y");
            int z = nbt.func_74762_e("Z");
            LPPosition pos = new LPPosition(x, y, z);
            int dim = nbt.func_74762_e("Dim");
            QueuedTasks.queueTask(() -> {
                TileEntity tile;
                WorldServer world = DimensionManager.getWorld((int)dim);
                if (world != null && (tile = pos.getTileEntity((World)world)) instanceof LogisticsSolidTileEntity) {
                    this.object = tile;
                    this.checkType();
                }
                return null;
            });
        } else {
            System.out.println("Unknown type to load");
        }
    }

    public void save(NBTTagCompound nbt) {
        if (this.object == null) {
            return;
        }
        if (this.object instanceof LPGlobalCCAccess) {
            nbt.func_74778_a("Type", "LPGlobalCCAccess");
        } else if (this.object instanceof CoreRoutedPipe) {
            LPPosition pos = ((CoreRoutedPipe)this.object).getLPPosition();
            nbt.func_74778_a("Type", "CoreRoutedPipe");
            nbt.func_74768_a("Dim", MainProxy.getDimensionForWorld(((CoreRoutedPipe)this.object).getWorld()));
            nbt.func_74768_a("X", pos.getX());
            nbt.func_74768_a("Y", pos.getY());
            nbt.func_74768_a("Z", pos.getZ());
        } else if (this.object instanceof CCItemIdentifier.CCItemIdentifierImplementation) {
            nbt.func_74778_a("Type", "CCItemIdentifierImplementation");
            ((CCItemIdentifier.CCItemIdentifierImplementation)this.object).getObject().makeNormalStack(1).func_77955_b(nbt);
        } else if (this.object instanceof CCItemIdentifierStack.CCItemIdentifierStackImplementation) {
            nbt.func_74778_a("Type", "CCItemIdentifierStackImplementation");
            ((CCItemIdentifierStack.CCItemIdentifierStackImplementation)this.object).getObject().makeNormalStack().func_77955_b(nbt);
        } else if (this.object instanceof CCItemIdentifierBuilder) {
            nbt.func_74778_a("Type", "CCItemIdentifierBuilder");
            ((CCItemIdentifierBuilder)this.object).build().makeNormalStack(1).func_77955_b(nbt);
        } else if (this.object instanceof LogisticsSolidTileEntity) {
            LPPosition pos = ((LogisticsSolidTileEntity)this.object).getLPPosition();
            nbt.func_74778_a("Type", "LogisticsSolidTileEntity");
            nbt.func_74768_a("Dim", MainProxy.getDimensionForWorld(((LogisticsSolidTileEntity)this.object).func_145831_w()));
            nbt.func_74768_a("X", pos.getX());
            nbt.func_74768_a("Y", pos.getY());
            nbt.func_74768_a("Z", pos.getZ());
        } else {
            System.out.println("Couldn't find mapping for: " + this.object.getClass());
        }
    }

    private void checkType() {
        if (this.object != null && CCObjectWrapper.getWrapperInformation(this.object.getClass()) != this.info) {
            System.out.println("WrapperInformationTypes didn't match");
            this.object = null;
        }
    }

    public Object[] call(Context context, Arguments arguments) {
        try {
            return this.help(context, arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

