/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.PlayerConfig;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.IPipeSignData;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCRenderTESR;
import logisticspipes.renderer.CustomBlockRenderer;
import logisticspipes.renderer.FluidRenderer;
import logisticspipes.renderer.TravelingItemRenderer;
import logisticspipes.renderer.newpipe.IRenderable;
import logisticspipes.renderer.newpipe.LogisticsNewPipeItemBoxRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.LPPosition;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelSign;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LogisticsRenderPipe
extends TileEntitySpecialRenderer {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private static final ResourceLocation SIGN = new ResourceLocation("textures/entity/sign.png");
    public static LogisticsNewRenderPipe secondRenderer = new LogisticsNewRenderPipe();
    public static LogisticsNewPipeItemBoxRenderer boxRenderer = new LogisticsNewPipeItemBoxRenderer();
    public static PlayerConfig config;
    private static final TravelingItemRenderer travelingItemRenderer;
    private static final Map<IPipeSignData, IRenderable> pipeSignRenderListMap;
    private static int localItemTestRenderList;
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final IntHashMap displayFluidLists;
    private final ModelSign modelSign;
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private final IBCRenderTESR bcRenderer = SimpleServiceLocator.buildCraftProxy.getBCRenderTESR();
    private final LPPosition pos = new LPPosition(0, 0, 0);

    public LogisticsRenderPipe() {
        this.modelSign = new ModelSign();
        this.modelSign.field_78165_b.field_78806_j = false;
        config = LogisticsPipes.getClientPlayerConfig();
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float partialTickTime) {
        if (!(tileentity instanceof LogisticsTileGenericPipe)) {
            return;
        }
        LogisticsTileGenericPipe pipe = (LogisticsTileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe instanceof CoreRoutedPipe) {
            this.renderPipeSigns((CoreRoutedPipe)pipe.pipe, x, y, z, partialTickTime);
        }
        double distance = Math.pow(Minecraft.func_71410_x().field_71439_g.field_70142_S - (double)tileentity.field_145851_c, 2.0) + Math.pow(Minecraft.func_71410_x().field_71439_g.field_70137_T - (double)tileentity.field_145848_d, 2.0) + Math.pow(Minecraft.func_71410_x().field_71439_g.field_70136_U - (double)tileentity.field_145849_e, 2.0);
        if (config.isUseNewRenderer()) {
            secondRenderer.renderTileEntityAt((LogisticsTileGenericPipe)tileentity, x, y, z, partialTickTime, distance);
        }
        if ((double)(config.getRenderPipeContentDistance() * config.getRenderPipeContentDistance()) < distance) {
            return;
        }
        this.bcRenderer.renderWires(pipe, x, y, z);
        this.bcRenderer.dynamicRenderPluggables(pipe, x, y, z);
        if (!pipe.isOpaque()) {
            if (pipe.pipe.transport instanceof PipeFluidTransportLogistics) {
                this.renderFluids(pipe.pipe, x, y, z);
            }
            if (pipe.pipe.transport instanceof PipeTransportLogistics) {
                this.renderSolids(pipe.pipe, x, y, z, partialTickTime);
            }
        }
    }

    private void renderSolids(CoreUnroutedPipe pipe, double x, double y, double z, float partialTickTime) {
        GL11.glPushMatrix();
        int count = 0;
        for (LPTravelingItem item : pipe.transport.items) {
            if (count >= 10) break;
            if (item.getPosition() > 1.0f || item.getPosition() < 0.0f || item.getItemIdentifierStack() == null || item.getContainer().field_145851_c != pipe.container.field_145851_c || item.getContainer().field_145848_d != pipe.container.field_145848_d || item.getContainer().field_145849_e != pipe.container.field_145849_e) continue;
            this.pos.reset(0.5, 0.5, 0.5);
            float f = item.getPosition() + item.getSpeed() * partialTickTime;
            double boxScale = 1.0;
            if ((double)f < 0.5) {
                if (item.input == ForgeDirection.UNKNOWN || !pipe.container.renderState.pipeConnectionMatrix.isConnected(item.input.getOpposite())) continue;
                this.pos.moveForward(item.input.getOpposite(), 0.5f - f);
            } else {
                if (item.output == ForgeDirection.UNKNOWN || !pipe.container.renderState.pipeConnectionMatrix.isConnected(item.output)) continue;
                this.pos.moveForward(item.output, f - 0.5f);
            }
            if (pipe.container.renderState.pipeConnectionMatrix.isTDConnected(item.input.getOpposite())) {
                boxScale = (double)f * 0.35 + 0.65;
            }
            if (pipe.container.renderState.pipeConnectionMatrix.isTDConnected(item.output)) {
                boxScale = (double)(1.0f - f) * 0.35 + 0.65;
            }
            if (pipe.container.renderState.pipeConnectionMatrix.isTDConnected(item.input.getOpposite()) && pipe.container.renderState.pipeConnectionMatrix.isTDConnected(item.output)) {
                boxScale = 0.65;
            }
            this.doRenderItem(item.getItemIdentifierStack(), pipe.container.func_145831_w(), x + this.pos.getXD(), y + this.pos.getYD(), z + this.pos.getZD(), 0.75f, boxScale, partialTickTime);
            ++count;
        }
        count = 0;
        float dist = 0.135f;
        this.pos.reset(0.5 + (double)dist, 0.5 + (double)dist, 0.5 + (double)dist);
        for (Pair pair : pipe.transport._itemBuffer) {
            if (pair == null || pair.getValue1() == null) continue;
            this.doRenderItem((ItemIdentifierStack)pair.getValue1(), pipe.container.func_145831_w(), x + this.pos.getXD(), y + this.pos.getYD(), z + this.pos.getZD(), 0.25f, 0.0, partialTickTime);
            if (++count >= 27) break;
            if (count % 9 == 0) {
                this.pos.moveForward(ForgeDirection.SOUTH, dist * 2.0f);
                this.pos.moveForward(ForgeDirection.EAST, dist * 2.0f);
                this.pos.moveForward(ForgeDirection.DOWN, dist);
                continue;
            }
            if (count % 3 == 0) {
                this.pos.moveForward(ForgeDirection.SOUTH, dist * 2.0f);
                this.pos.moveForward(ForgeDirection.WEST, dist);
                continue;
            }
            this.pos.moveForward(ForgeDirection.NORTH, dist);
        }
        GL11.glPopMatrix();
    }

    public void doRenderItem(ItemIdentifierStack itemIdentifierStack, World worldObj, double x, double y, double z, float renderScale, double boxScale, float partialTickTime) {
        if (config.isUseNewRenderer() && boxScale != 0.0) {
            boxRenderer.doRenderItem(itemIdentifierStack, x, y, z, boxScale);
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
        travelingItemRenderer.renderInWorld(worldObj, itemIdentifierStack.getItem(), partialTickTime);
        GL11.glPopMatrix();
    }

    private boolean needDistance(List<Pair<ForgeDirection, IPipeSign>> list) {
        boolean result;
        ArrayList<Pair<ForgeDirection, IPipeSign>> copy = new ArrayList<Pair<ForgeDirection, IPipeSign>>(list);
        Iterator iter = copy.iterator();
        boolean north = false;
        boolean south = false;
        boolean east = false;
        boolean west = false;
        while (iter.hasNext()) {
            Pair pair = (Pair)iter.next();
            if (pair.getValue1() == ForgeDirection.UP || pair.getValue1() == ForgeDirection.DOWN || pair.getValue1() == ForgeDirection.UNKNOWN) {
                iter.remove();
            }
            if (pair.getValue1() == ForgeDirection.NORTH) {
                north = true;
            }
            if (pair.getValue1() == ForgeDirection.SOUTH) {
                south = true;
            }
            if (pair.getValue1() == ForgeDirection.EAST) {
                east = true;
            }
            if (pair.getValue1() != ForgeDirection.WEST) continue;
            west = true;
        }
        boolean bl = result = copy.size() > 1;
        if (copy.size() == 2) {
            if (north && south) {
                result = false;
            }
            if (east && west) {
                result = false;
            }
        }
        return result;
    }

    private void renderPipeSigns(CoreRoutedPipe pipe, double x, double y, double z, float partialTickTime) {
        if (!pipe.getPipeSigns().isEmpty()) {
            List<Pair<ForgeDirection, IPipeSign>> list = pipe.getPipeSigns();
            for (Pair<ForgeDirection, IPipeSign> pair : list) {
                if (pipe.container.renderState.pipeConnectionMatrix.isConnected(pair.getValue1())) continue;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
                switch (pair.getValue1()) {
                    case UP: {
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case DOWN: {
                        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case NORTH: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case SOUTH: {
                        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case EAST: {
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                    case WEST: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        if (!this.needDistance(list)) break;
                        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.15f);
                        break;
                    }
                }
                this.renderSign(pipe, pair.getValue2(), partialTickTime);
                GL11.glPopMatrix();
            }
        }
    }

    private void renderSign(CoreRoutedPipe pipe, IPipeSign type, float partialTickTime) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        float signScale = 0.6666667f;
        GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)-0.36f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SIGN);
        GL11.glPushMatrix();
        GL11.glScalef((float)signScale, (float)(-signScale), (float)(-signScale));
        this.modelSign.func_78164_a();
        GL11.glPopMatrix();
        GL11.glTranslatef((float)-0.32f, (float)(0.5f * signScale + 0.08f), (float)(0.07f * signScale));
        IPipeSignData data = type.getRenderData(pipe);
        IRenderable renderList = pipeSignRenderListMap.get(data);
        if (data.isListCompatible(this)) {
            if (renderList == null || renderList.isInvalid() || !renderList.isFilled()) {
                renderList = SimpleServiceLocator.renderListHandler.getNewRenderList();
                pipeSignRenderListMap.put(data, renderList);
                renderList.startListCompile();
                type.render(pipe, this);
                renderList.stopCompile();
            }
            renderList.render();
        } else {
            type.render(pipe, this);
        }
    }

    public void renderItemStackOnSign(ItemStack itemstack) {
        if (itemstack == null || itemstack.func_77973_b() == null) {
            return;
        }
        Item item = itemstack.func_77973_b();
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.INVENTORY);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(itemstack.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        GL11.glPushMatrix();
        if (customRenderer != null) {
            if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, itemstack, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK)) {
                GL11.glScalef((float)0.2f, (float)-0.2f, (float)-0.01f);
                GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)16384);
                GL11.glDisable((int)16385);
                GL11.glDisable((int)2903);
                customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, itemstack, new Object[]{this.renderBlocks});
                GL11.glEnable((int)2896);
                GL11.glEnable((int)16384);
                GL11.glEnable((int)16385);
                GL11.glEnable((int)2903);
            } else {
                GL11.glScalef((float)0.018f, (float)-0.018f, (float)-0.01f);
                GL11.glTranslatef((float)-7.0f, (float)-8.0f, (float)0.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)16384);
                GL11.glDisable((int)16385);
                GL11.glDisable((int)2903);
                customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, itemstack, new Object[]{this.renderBlocks});
                GL11.glEnable((int)2896);
                GL11.glEnable((int)16384);
                GL11.glEnable((int)16385);
                GL11.glEnable((int)2903);
            }
        } else if (item instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item).func_149645_b())) {
            GL11.glScalef((float)0.2f, (float)-0.2f, (float)-0.01f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderBlocks.field_147844_c = false;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glDisable((int)2903);
            this.renderBlocks.func_147800_a(Block.func_149634_a((Item)item), itemstack.func_77960_j(), 1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)16385);
            GL11.glEnable((int)2903);
        } else {
            GL11.glScalef((float)0.02f, (float)-0.02f, (float)-0.01f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)16384);
            GL11.glDisable((int)16385);
            GL11.glDisable((int)2903);
            GL11.glTranslatef((float)-8.0f, (float)-8.0f, (float)0.0f);
            if (item.func_77623_v()) {
                for (int var14 = 0; var14 < item.getRenderPasses(itemstack.func_77960_j()); ++var14) {
                    IIcon var15 = item.func_77618_c(itemstack.func_77960_j(), var14);
                    this.renderItem(var15);
                }
            } else {
                this.renderItem(item.func_77650_f(itemstack));
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)16384);
            GL11.glEnable((int)16385);
            GL11.glEnable((int)2903);
        }
        GL11.glPopMatrix();
    }

    private void renderItem(IIcon par3Icon) {
        if (par3Icon == null) {
            return;
        }
        int par1 = 0;
        int par2 = 0;
        int par4 = 16;
        int par5 = 16;
        double zLevel = 0.0;
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + par5), zLevel, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + par5), zLevel, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(par1 + par4), (double)(par2 + 0), zLevel, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(par1 + 0), (double)(par2 + 0), zLevel, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public String cut(String name, FontRenderer renderer) {
        if (renderer.func_78256_a(name) < 90) {
            return name;
        }
        StringBuilder sum = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (renderer.func_78256_a(sum.toString() + name.charAt(i) + "...") >= 90) {
                return sum + "...";
            }
            sum.append(name.charAt(i));
        }
        return sum.toString();
    }

    private void renderFluids(CoreUnroutedPipe pipe, double x, double y, double z) {
        DisplayFluidList d;
        PipeFluidTransportLogistics trans = (PipeFluidTransportLogistics)pipe.transport;
        boolean needsRender = false;
        for (int i = 0; i < 7; ++i) {
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        int skylight = pipe.container.getWorld().func_72925_a(EnumSkyBlock.Sky, pipe.getX(), pipe.getY(), pipe.getZ());
        int blocklight = pipe.container.getWorld().func_72925_a(EnumSkyBlock.Block, pipe.getX(), pipe.getY(), pipe.getZ());
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayFluidList d2;
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0 || (d2 = this.getListFromBuffer(fluidStack, skylight, blocklight, fluidStack.getFluid().getLuminosity(fluidStack), pipe.container.func_145831_w())) == null) continue;
            int stage = (int)((float)fluidStack.amount / (float)trans.getSideCapacity() * 39.0f);
            if (stage >= 40) {
                stage = 39;
            }
            if (stage < 0) {
                stage = 0;
            }
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case NORTH: 
                case SOUTH: 
                case EAST: 
                case WEST: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_147499_a(TextureMap.field_110575_b);
            FluidRenderer.setColorForFluidStack(fluidStack);
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        FluidStack fluidStack = trans.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (fluidStack != null && fluidStack.amount > 0 && (d = this.getListFromBuffer(fluidStack, skylight, blocklight, fluidStack.getFluid().getLuminosity(fluidStack), pipe.container.func_145831_w())) != null) {
            int stage = (int)((float)fluidStack.amount / (float)trans.getInnerCapacity() * 39.0f);
            this.func_147499_a(TextureMap.field_110575_b);
            FluidRenderer.setColorForFluidStack(fluidStack);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayFluidList getListFromBuffer(FluidStack stack, int skylight, int blocklight, int flags, World world) {
        int liquidId = stack.getFluidID();
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayFluidLists(liquidId, skylight, blocklight, flags, world);
    }

    private DisplayFluidList getDisplayFluidLists(int liquidId, int skylight, int blocklight, int flags, World world) {
        int finalBlockLight = Math.max(flags & 0x1F, blocklight);
        int listId = (liquidId & 0x3FFFF) << 13 | (flags & 0xE0 | finalBlockLight) << 5 | skylight & 0x1F;
        if (displayFluidLists.func_76037_b(listId)) {
            return (DisplayFluidList)displayFluidLists.func_76041_a(listId);
        }
        Fluid fluid = FluidRegistry.getFluid((int)liquidId);
        if (fluid == null) {
            return null;
        }
        DisplayFluidList d = new DisplayFluidList();
        displayFluidLists.func_76038_a(listId, (Object)d);
        CustomBlockRenderer.RenderInfo block = new CustomBlockRenderer.RenderInfo();
        block.baseBlock = fluid.getBlock() != null ? fluid.getBlock() : Blocks.field_150355_j;
        block.texture = fluid.getStillIcon();
        block.brightness = skylight << 16 | finalBlockLight;
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    public boolean isRenderListCompatible(ItemStack stack) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.0, (double)0.0, (double)0.0);
        try {
            this.renderItemStackOnSign(stack);
            int i = GL11.glGetError();
            if (i != 0) {
                GL11.glPopMatrix();
                return false;
            }
            if (localItemTestRenderList == -1) {
                localItemTestRenderList = GLAllocation.func_74526_a((int)1);
            }
            GL11.glNewList((int)localItemTestRenderList, (int)4864);
            i = GL11.glGetError();
            if (i != 0) {
                GL11.glPopMatrix();
                return false;
            }
            this.renderItemStackOnSign(stack);
            i = GL11.glGetError();
            if (i != 0) {
                GL11.glPopMatrix();
                return false;
            }
            GL11.glEndList();
            i = GL11.glGetError();
            if (i != 0) {
                GL11.glPopMatrix();
                return false;
            }
            GL11.glCallList((int)localItemTestRenderList);
            i = GL11.glGetError();
            if (i != 0) {
                GL11.glPopMatrix();
                return false;
            }
            GL11.glPopMatrix();
            return true;
        }
        catch (Exception exception) {
            GL11.glPopMatrix();
            return false;
        }
    }

    static {
        travelingItemRenderer = new TravelingItemRenderer();
        pipeSignRenderListMap = new HashMap<IPipeSignData, IRenderable>();
        localItemTestRenderList = -1;
        displayFluidLists = new IntHashMap();
    }

    private static class DisplayFluidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayFluidList() {
        }
    }
}

