/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VBOManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.CustomBlockRenderer;
import logisticspipes.renderer.FluidContainerRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LogisticsNewPipeItemBoxRenderer {
    private static final int RENDER_SIZE = 40;
    private int renderList = -1;
    private static final ResourceLocation BLOCKS = new ResourceLocation("textures/atlas/blocks.png");
    private static final Map<FluidIdentifier, int[]> renderLists = new HashMap<FluidIdentifier, int[]>();

    public void doRenderItem(ItemIdentifierStack itemIdentifierStack, double x, double y, double z, double boxScale) {
        FluidStack f;
        if (LogisticsNewRenderPipe.innerTransportBox == null) {
            return;
        }
        GL11.glPushMatrix();
        if (this.renderList == -1) {
            this.renderList = LogisticsPipes.enableVBO ? this.generateInnerBoxVBO() : this.generateInnerBoxDisplayList();
        }
        GL11.glTranslated((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BLOCKS);
        GL11.glScaled((double)boxScale, (double)boxScale, (double)boxScale);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        if (LogisticsPipes.enableVBO) {
            VBOManager.get((int)this.renderList).render();
        } else {
            GL11.glCallList((int)this.renderList);
        }
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glScaled((double)(1.0 / boxScale), (double)(1.0 / boxScale), (double)(1.0 / boxScale));
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        if (itemIdentifierStack != null && itemIdentifierStack.getItem().item instanceof LogisticsFluidContainer && (f = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(itemIdentifierStack)) != null) {
            FluidContainerRenderer.skipNext = true;
            int list = this.getRenderListFor(f);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (LogisticsPipes.enableVBO) {
                VBOManager.get((int)list).render();
            } else {
                GL11.glCallList((int)list);
            }
            GL11.glPopAttrib();
        }
        GL11.glPopMatrix();
    }

    private int getRenderListFor(FluidStack fluid) {
        int pos;
        int[] array = renderLists.computeIfAbsent(FluidIdentifier.get(fluid), k -> new int[40]);
        if (array[pos = Math.min((int)((float)Math.min(fluid.amount, 5000) * 1.0f * 40.0f / 5000.0f), 39)] != 0) {
            return array[pos];
        }
        float ratio = (float)pos * 1.0f / 39.0f;
        CustomBlockRenderer.RenderInfo block = new CustomBlockRenderer.RenderInfo();
        block.baseBlock = fluid.getFluid().getBlock();
        block.texture = fluid.getFluid().getStillIcon();
        block.minX = 0.32;
        block.maxX = 0.68;
        block.minY = 0.32;
        block.maxY = 0.32 + 0.36000000000000004 * (double)ratio;
        block.minZ = 0.32;
        block.maxZ = 0.68;
        array[pos] = LogisticsPipes.enableVBO ? this.generateVBO(block) : this.generateDisplayList(block);
        return array[pos];
    }

    private int generateDisplayList(CustomBlockRenderer.RenderInfo block) {
        int id = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)id, (int)4864);
        CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, 0, 0, 0, false, true);
        GL11.glEndList();
        return id;
    }

    private int generateVBO(CustomBlockRenderer.RenderInfo block) {
        TessellatorManager.startCapturing();
        CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, 0, 0, 0, false, true);
        VertexBuffer vbo = TessellatorManager.stopCapturingToVBO((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE_NORMAL);
        int vboID = VBOManager.generateDisplayLists((int)1);
        VBOManager.registerVBO((int)vboID, (VertexBuffer)vbo);
        return vboID;
    }

    private int generateInnerBoxDisplayList() {
        int id = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)id, (int)4864);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        LogisticsNewRenderPipe.innerTransportBox.render(LogisticsNewRenderPipe.innerBoxTexture);
        tess.func_78381_a();
        GL11.glEndList();
        return id;
    }

    private int generateInnerBoxVBO() {
        TessellatorManager.startCapturing();
        CapturingTessellator tess = (CapturingTessellator)TessellatorManager.get();
        tess.func_78382_b();
        LogisticsNewRenderPipe.innerTransportBox.render(LogisticsNewRenderPipe.innerBoxTexture);
        tess.func_78381_a();
        VertexBuffer vbo = TessellatorManager.stopCapturingToVBO((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE_NORMAL);
        int vboID = VBOManager.generateDisplayLists((int)1);
        VBOManager.registerVBO((int)vboID, (VertexBuffer)vbo);
        return vboID;
    }
}

