/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;

public class LogisticsDictPromise
extends LogisticsPromise {
    private final DictResource resource;

    public LogisticsDictPromise(DictResource item, int stackSize, IProvideItems sender, IOrderInfoProvider.ResourceType type) {
        super(item.stack.getItem(), stackSize, sender, type);
        this.resource = item;
        this.resource.stack = this.resource.stack.clone();
        this.resource.stack.setStackSize(stackSize);
    }

    @Override
    public IExtraPromise split(int more) {
        this.numberOfItems -= more;
        this.resource.stack.setStackSize(this.numberOfItems);
        return new LogisticsExtraDictPromise(this.getResource().clone(), more, this.sender, false);
    }

    @Override
    public IOrderInfoProvider fullFill(IResource requestType, IAdditionalTargetInformation info) {
        IRequestItems destination;
        if (requestType instanceof ItemResource) {
            destination = ((ItemResource)requestType).getTarget();
        } else if (requestType instanceof DictResource) {
            destination = ((DictResource)requestType).getTarget();
        } else {
            throw new UnsupportedOperationException();
        }
        return this.sender.fullFill(this, destination, info);
    }

    public DictResource getResource() {
        return this.resource;
    }
}

