/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logisticspipes.routing.order.LogisticsOrder;

public class LogisticsOrderLinkedList<E extends LogisticsOrder, I>
implements Iterable<E> {
    private final IIdentityProvider<E, I> identifyer;
    private final Map<I, Integer> extraSize = new HashMap<I, Integer>();
    private final LinkedList<E> list = new LinkedList();
    private final List<E> unmodifiable = Collections.unmodifiableList(this.list);
    private int globalExtraCount = 0;

    public LogisticsOrderLinkedList(IIdentityProvider<E, I> identifyer) {
        this.identifyer = identifyer;
    }

    public E getFirst() {
        return (E)((LogisticsOrder)this.list.getFirst());
    }

    public void addLast(E order) {
        this.list.addLast(order);
        I ident = this.identifyer.getIdentity(order);
        if (this.identifyer.isExtra(order)) {
            int prev = 0;
            if (this.extraSize.containsKey(ident)) {
                prev = this.extraSize.get(ident);
            }
            this.extraSize.put(ident, prev + 1);
            ++this.globalExtraCount;
        } else if (this.extraSize.containsKey(ident) && this.extraSize.get(ident) > 0) {
            LinkedList<LogisticsOrder> toMove = new LinkedList<LogisticsOrder>();
            for (LogisticsOrder lElem : this.list) {
                if (!this.identifyer.isExtra(lElem) || !ident.equals(this.identifyer.getIdentity(lElem))) continue;
                toMove.add(lElem);
            }
            for (LogisticsOrder move : toMove) {
                this.list.remove(move);
                this.list.addLast(move);
            }
        }
    }

    public void removeAll(List<E> orders) {
        this.list.removeAll(orders);
        for (LogisticsOrder order : orders) {
            this.elemRemove(order);
        }
    }

    private void elemRemove(E elem) {
        if (this.identifyer.isExtra(elem)) {
            I ident = this.identifyer.getIdentity(elem);
            int prev = 0;
            if (this.extraSize.containsKey(ident)) {
                prev = this.extraSize.get(ident);
            }
            if (prev > 0) {
                this.extraSize.put(ident, prev - 1);
            }
            --this.globalExtraCount;
        }
    }

    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.unmodifiable.iterator();
    }

    public boolean hasExtras() {
        return this.globalExtraCount != 0;
    }

    public E removeFirst() {
        LogisticsOrder elem = (LogisticsOrder)this.list.removeFirst();
        this.elemRemove(elem);
        return (E)elem;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static interface IIdentityProvider<A, B> {
        public B getIdentity(A var1);

        public boolean isExtra(A var1);
    }
}

