/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.pathfinder.changedetection.LPWorldAccess;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;

public class LPTickHandler {
    private static final Map<World, LPWorldInfo> worldInfo = new MapMaker().weakKeys().makeMap();

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        FluidIdentifier.initFromForge(true);
        SimpleServiceLocator.clientBufferHandler.clientTick(event);
        MainProxy.proxy.tickClient();
        DebugGuiController.instance().execClient();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        HudUpdateTick.tick();
        SimpleServiceLocator.craftingPermissionManager.tick();
        SimpleServiceLocator.serverBufferHandler.serverTick(event);
        MainProxy.proxy.tickServer();
        DebugGuiController.instance().execServer();
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        LPWorldInfo info = LPTickHandler.getWorldInfo(event.world);
        info.worldTick++;
    }

    public static LPWorldInfo getWorldInfo(World world) {
        LPWorldInfo info = worldInfo.get(world);
        if (info == null) {
            info = new LPWorldInfo();
            worldInfo.put(world, info);
            world.func_72954_a((IWorldAccess)new LPWorldAccess(world, info));
        }
        return info;
    }

    public static class LPWorldInfo {
        private long worldTick = 0L;
        private Set<LPPosition> updateQueued = new HashSet<LPPosition>();

        public void setUpdateQueued(Set<LPPosition> updateQueued) {
            this.updateQueued = updateQueued;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LPWorldInfo)) {
                return false;
            }
            LPWorldInfo other = (LPWorldInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWorldTick() != other.getWorldTick()) {
                return false;
            }
            Set<LPPosition> this$updateQueued = this.getUpdateQueued();
            Set<LPPosition> other$updateQueued = other.getUpdateQueued();
            return !(this$updateQueued == null ? other$updateQueued != null : !((Object)this$updateQueued).equals(other$updateQueued));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LPWorldInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $worldTick = this.getWorldTick();
            result = result * 59 + (int)($worldTick >>> 32 ^ $worldTick);
            Set<LPPosition> $updateQueued = this.getUpdateQueued();
            result = result * 59 + ($updateQueued == null ? 43 : ((Object)$updateQueued).hashCode());
            return result;
        }

        public String toString() {
            return "LPTickHandler.LPWorldInfo(worldTick=" + this.getWorldTick() + ", updateQueued=" + this.getUpdateQueued() + ")";
        }

        public long getWorldTick() {
            return this.worldTick;
        }

        private void setWorldTick(long worldTick) {
            this.worldTick = worldTick;
        }

        public Set<LPPosition> getUpdateQueued() {
            return this.updateQueued;
        }
    }
}

