/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.io;

import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.CastlingRights;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.Rank;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.pieces.Piece;
import eu.usrv.yamcore.auxiliary.LogHelper;

public class DrawBoard {
    private static LogHelper mLog = new LogHelper("LootGames - ChessEngine");

    public static void drawBoard(Board b) {
        StringBuffer board = new StringBuffer();
        for (Rank r : Rank.values()) {
            for (File f : File.values()) {
                Piece p = b.getPiece(Square.valueOf(f, r));
                board.append(p == null ? "-" : p.toString());
                if (!f.equals((Object)File.FILE_H)) continue;
                if (r.equals((Object)Rank.RANK_7)) {
                    if (b.getPlayerToMove().isWhite()) {
                        board.append("\twhite to move");
                        continue;
                    }
                    board.append("\tblack to move");
                    continue;
                }
                if (r.equals((Object)Rank.RANK_6)) {
                    CastlingRights[] crs;
                    board.append("\tcastling rights: ");
                    for (CastlingRights cr : crs = CastlingRights.values()) {
                        if (!b.hasCastlingRight(cr)) continue;
                        board.append(cr.getLabel());
                    }
                    continue;
                }
                if (r.equals((Object)Rank.RANK_5)) {
                    board.append("\t");
                    board.append(b.getEPSquare() == null ? "no ep" : "ep=" + b.getEPSquare());
                    continue;
                }
                if (r.equals((Object)Rank.RANK_4)) {
                    board.append("\tfifty=" + b.getFiftyCounter());
                    continue;
                }
                if (!r.equals((Object)Rank.RANK_3)) continue;
                board.append("\tmove counter=" + b.getMoveCounter());
            }
            board.append("\n");
        }
        mLog.info((Object)board);
    }
}

