/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.compatibility;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.text.View;

public interface MenuItemLayoutHelper {
    public static MenuItemLayoutHelper create(JMenuItem mi, Icon checkIcon, Icon arrowIcon, Rectangle viewRect, int defaultTextIconGap, String acceleratorDelimiter, boolean leftToRight, Font font, Font acceleratorFont, String propertyPrefix) {
        boolean useCheckAndArrow = com.intellij.util.ui.MenuItemLayoutHelper.useCheckAndArrow(mi);
        return new com.intellij.util.ui.MenuItemLayoutHelper(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, acceleratorDelimiter, leftToRight, font, acceleratorFont, useCheckAndArrow, propertyPrefix);
    }

    public static void uninstall(JMenuItem mi) {
        com.intellij.util.ui.MenuItemLayoutHelper.clearUsedParentClientProperties(mi);
    }

    public MILayoutResult layoutMenuItem();

    public JMenuItem getMenuItem();

    public FontMetrics getFontMetrics();

    public FontMetrics getAccFontMetrics();

    public Icon getIcon();

    public Icon getCheckIcon();

    public Icon getArrowIcon();

    public String getText();

    public String getAccText();

    public boolean useCheckAndArrow();

    public boolean isTopLevelMenu();

    public View getHtmlView();

    public int getGap();

    public int getLeadingGap();

    public int getAfterCheckIconGap();

    public int getMinTextOffset();

    public Rectangle getViewRect();

    public MIRectSize getIconSize();

    public MIRectSize getTextSize();

    public MIRectSize getAccSize();

    public MIRectSize getCheckSize();

    public MIRectSize getArrowSize();

    public MIRectSize getLabelSize();

    public static Rectangle createMaxRect() {
        return new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static void addMaxWidth(MIRectSize size, int gap, Dimension result) {
        if (size.getMaxWidth() > 0) {
            result.width += size.getMaxWidth() + gap;
        }
    }

    public static interface MIRectSize {
        public int getWidth();

        public int getHeight();

        public int getOrigWidth();

        public int getMaxWidth();

        public void setWidth(int var1);

        public void setHeight(int var1);
    }

    public static interface MILayoutResult {
        public Rectangle getCheckRect();

        public Rectangle getIconRect();

        public Rectangle getTextRect();

        public Rectangle getAccRect();

        public Rectangle getArrowRect();
    }
}

