/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.border;

import com.github.weisj.swingdsl.visualpadding.VisualPaddingProvider;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import org.jetbrains.annotations.NotNull;

public class MarginBorderWrapper
extends CompoundBorder
implements VisualPaddingProvider {
    public MarginBorderWrapper(Border border) {
        super(border, new BasicBorders.MarginBorder());
    }

    public static void installBorder(JComponent c) {
        Border border = c.getBorder();
        if (!(border instanceof MarginBorderWrapper)) {
            c.setBorder(MarginBorderWrapper.wrapBorder(border));
        }
    }

    private static MarginBorderWrapper wrapBorder(Border border) {
        if (border == null || border instanceof UIResource) {
            return new UIBorder(border);
        }
        return new MarginBorderWrapper(border);
    }

    public static void uninstallBorder(JComponent c) {
        Border border = c.getBorder();
        if (border instanceof MarginBorderWrapper) {
            Border outside = ((MarginBorderWrapper)border).getOutsideBorder();
            c.setBorder(outside);
        }
    }

    public static Border getBorder(JComponent c) {
        Border border = c.getBorder();
        if (border instanceof MarginBorderWrapper) {
            border = ((MarginBorderWrapper)border).getOutsideBorder();
        }
        return border;
    }

    @Override
    @NotNull
    public Insets getVisualPaddings(@NotNull Component component) {
        if (this.outsideBorder instanceof VisualPaddingProvider) {
            return ((VisualPaddingProvider)((Object)this.outsideBorder)).getVisualPaddings(component);
        }
        return new Insets(0, 0, 0, 0);
    }

    public static class UIBorder
    extends MarginBorderWrapper
    implements UIResource {
        public UIBorder(Border border) {
            super(border);
        }
    }
}

