/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.focus;

import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class FocusParentHelper {
    public static final String KEY_FOCUS_PARENT = "focusParent";
    public static final String KEY_FOCUS_ACTION = "focusOnParentChangedAction";
    private static final Map<Component, Component> listeners = new WeakHashMap<Component, Component>();

    public static void updateFocusParentRegistry(JComponent c, Component parent) {
        if (parent == null) {
            c.putClientProperty(KEY_FOCUS_ACTION, null);
            listeners.remove(c);
        } else {
            listeners.put(c, parent);
        }
    }

    public static void setFocusParent(JComponent c, JComponent focusParent) {
        FocusParentHelper.setFocusParent(c, focusParent, Component::repaint);
    }

    public static void setFocusParent(JComponent c, JComponent focusParent, OnFocusChangedAction focusChangedAction) {
        if (c == null) {
            return;
        }
        c.putClientProperty(KEY_FOCUS_PARENT, focusParent);
        FocusParentHelper.updateFocusParentRegistry(c, focusParent);
        if (focusParent != null) {
            c.putClientProperty(KEY_FOCUS_ACTION, focusChangedAction);
        }
    }

    static {
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (!(event instanceof FocusEvent)) {
                return;
            }
            FocusEvent e = (FocusEvent)event;
            if (e.getID() != 1004 && e.getID() != 1005) {
                return;
            }
            Component comp = e.getComponent();
            listeners.forEach((c, focusParent) -> {
                if (SwingUtilities.isDescendingFrom(comp, focusParent)) {
                    OnFocusChangedAction onFocusChangedAction = PropertyUtil.getObject(c, KEY_FOCUS_ACTION, OnFocusChangedAction.class);
                    if (onFocusChangedAction != null) {
                        onFocusChangedAction.accept(c);
                    } else {
                        c.repaint();
                    }
                }
            });
        }, 4L);
    }

    public static interface OnFocusChangedAction
    extends Consumer<Component> {
    }
}

