/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.decorations;

import com.github.weisj.darklaf.platform.CustomTitlePane;
import com.github.weisj.darklaf.platform.DecorationsProvider;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.TitlePaneLayoutInfo;
import com.github.weisj.darklaf.platform.decorations.AbstractNativeDecorationsRootPaneUI;
import com.github.weisj.darklaf.platform.decorations.DefaultDecorationsProvider;
import com.github.weisj.darklaf.platform.macos.MacOSDecorationsProvider;
import com.github.weisj.darklaf.platform.windows.WindowsDecorationsProvider;
import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Properties;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.UIDefaults;
import javax.swing.plaf.RootPaneUI;

public class NativeDecorationsManager {
    private static NativeDecorationsManager sharedInstance;
    private DecorationsProvider decorationsProvider;
    private boolean decorationsEnabled = true;

    public static NativeDecorationsManager getSharedInstance() {
        if (sharedInstance == null) {
            NativeDecorationsManager.setSharedInstance(new NativeDecorationsManager());
        }
        return sharedInstance;
    }

    public static void setSharedInstance(NativeDecorationsManager handler) {
        sharedInstance = handler;
    }

    public NativeDecorationsManager() {
        this(true);
    }

    public NativeDecorationsManager(boolean allowNativeDecorations) {
        try {
            this.decorationsProvider = SystemInfo.isWindows && allowNativeDecorations ? new WindowsDecorationsProvider() : (SystemInfo.isMac && allowNativeDecorations ? new MacOSDecorationsProvider() : new DefaultDecorationsProvider());
        }
        catch (Throwable e) {
            this.decorationsProvider = new DefaultDecorationsProvider();
        }
    }

    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        if (!this.decorationsProvider.isCustomDecorationSupported()) {
            return DefaultDecorationsProvider.createNoOPTitlePane();
        }
        return this.decorationsProvider.createTitlePane(rootPane, decorationStyle, window);
    }

    public void installPopupWindow(Window window) {
        if (!this.decorationsProvider.isCustomDecorationSupported()) {
            return;
        }
        this.decorationsProvider.installPopupWindow(window);
    }

    public void uninstallPopupWindow(Window window) {
        if (!this.decorationsProvider.isCustomDecorationSupported()) {
            return;
        }
        this.decorationsProvider.uninstallPopupWindow(window);
    }

    public boolean isCustomDecorationSupported() {
        return this.decorationsProvider.isCustomDecorationSupported() && this.decorationsEnabled;
    }

    public void initialize() {
        this.decorationsProvider.initialize();
    }

    public void loadDecorationProperties(Properties uiProps, UIDefaults defaults) {
        IconLoader iconLoader = IconLoader.get(this.decorationsProvider.getClass());
        for (String path : this.decorationsProvider.getPropertyResourcePaths()) {
            PropertyLoader.putProperties(PropertyLoader.loadProperties(this.decorationsProvider.getClass(), path, ""), uiProps, defaults, iconLoader);
        }
    }

    public void setDecorationsEnabled(boolean enabled) {
        this.decorationsEnabled = enabled;
    }

    public void adjustContentArea(JRootPane root, Rectangle rect) {
        this.decorationsProvider.adjustContentArea(root, rect);
    }

    public boolean supportsNativeTitleText() {
        return this.decorationsProvider.supportsNativeTitleLabel();
    }

    public TitlePaneLayoutInfo titlePaneLayoutInfo(JRootPane rootPane) {
        RootPaneUI ui = rootPane.getUI();
        if (!(ui instanceof AbstractNativeDecorationsRootPaneUI)) {
            throw new IllegalStateException("UI is not of type " + AbstractNativeDecorationsRootPaneUI.class);
        }
        return this.decorationsProvider.titlePaneLayoutInfo(((AbstractNativeDecorationsRootPaneUI)ui).titlePane());
    }

    public TitlePaneLayoutInfo titlePaneLayoutInfo(RootPaneContainer frameOrDialog) {
        return this.titlePaneLayoutInfo(frameOrDialog.getRootPane());
    }
}

