/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme;

import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.theme.ThemeDelegate;
import com.github.weisj.darklaf.theme.info.PresetIconRule;
import com.github.weisj.darklaf.theme.laf.RenamedTheme;
import com.github.weisj.darklaf.theme.spec.AccentColorRule;
import com.github.weisj.darklaf.theme.spec.ColorToneRule;
import com.github.weisj.darklaf.theme.spec.ContrastRule;
import com.github.weisj.darklaf.theme.spec.FontPrototype;
import com.github.weisj.darklaf.theme.spec.FontSizeRule;
import com.github.weisj.darklaf.util.LogUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.text.html.StyleSheet;

public abstract class Theme
implements Comparable<Theme>,
Serializable {
    private static final Logger LOGGER = LogUtil.getLogger(Theme.class);
    private final FontSizeRule fontSizeRule;
    private final FontPrototype fontPrototype;
    private final AccentColorRule accentColorRule;

    public Theme() {
        this(null, null, null);
    }

    public Theme(FontSizeRule fontSizeRule, FontPrototype fontPrototype, AccentColorRule accentColorRule) {
        this.fontSizeRule = fontSizeRule != null ? fontSizeRule : FontSizeRule.getDefault();
        this.fontPrototype = fontPrototype != null ? fontPrototype : FontPrototype.getDefault();
        this.accentColorRule = accentColorRule != null ? accentColorRule : AccentColorRule.getDefault();
    }

    public static Theme baseThemeOf(Theme theme) {
        return theme.derive(FontSizeRule.getDefault(), FontPrototype.getDefault(), AccentColorRule.getDefault());
    }

    public Theme withDisplayName(String newName) {
        return new RenamedTheme(this, newName);
    }

    public Theme derive(FontSizeRule fontSizeRule, FontPrototype fontPrototype, AccentColorRule accentColorRule) {
        return new ThemeDelegate(this, fontSizeRule, fontPrototype, accentColorRule);
    }

    public Theme copy() {
        return new ThemeDelegate(this);
    }

    public static boolean isDark(Theme theme) {
        if (theme == null) {
            return false;
        }
        return theme.getColorToneRule() == ColorToneRule.DARK;
    }

    public static boolean isHighContrast(Theme theme) {
        if (theme == null) {
            return false;
        }
        return theme.getContrastRule() == ContrastRule.HIGH_CONTRAST;
    }

    public void loadDefaults(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        PropertyLoader.putProperties(this.loadPropertyFile("defaults"), properties, currentDefaults, iconResolver);
    }

    public void customizeGlobals(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
    }

    public void customizeIconTheme(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
    }

    public void loadIconTheme(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        Properties props;
        PresetIconRule iconTheme = this.getPresetIconRule();
        switch (iconTheme) {
            case DARK: {
                props = PropertyLoader.loadProperties(Theme.class, "dark_icons", "icon_presets/");
                break;
            }
            case LIGHT: {
                props = PropertyLoader.loadProperties(Theme.class, "light_icons", "icon_presets/");
                break;
            }
            default: {
                props = this.loadPropertyFile("icons");
            }
        }
        PropertyLoader.putProperties(props, properties, currentDefaults, iconResolver);
    }

    public void customizePlatformProperties(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
    }

    public void customizeUIProperties(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
    }

    protected abstract PresetIconRule getPresetIconRule();

    protected final void loadCustomProperties(String propertySuffix, Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        PropertyLoader.putProperties(this.loadPropertyFile(propertySuffix), properties, currentDefaults, iconResolver);
    }

    public Properties loadAccentProperties() {
        return this.loadPropertyFile("accents", true);
    }

    protected final Properties load(String name) {
        return this.loadWithClass(name, this.getLoaderClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Properties loadWithClass(String name, Class<?> loaderClass) {
        Properties properties = new Properties();
        try (InputStream stream = loaderClass.getResourceAsStream(name);){
            if (stream == null) {
                LOGGER.log(Level.SEVERE, "Could not load " + name + ". File not found");
                Properties properties2 = properties;
                return properties2;
            }
            properties.load(stream);
            return properties;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not load " + name + ". " + e.getMessage(), e);
        }
        return properties;
    }

    public StyleSheet loadStyleSheet() {
        return new StyleSheet();
    }

    public String toString() {
        return this.getName();
    }

    protected String getResourcePath() {
        return "";
    }

    public abstract String getPrefix();

    public abstract String getName();

    public String getDisplayName() {
        return this.getName();
    }

    protected abstract Class<? extends Theme> getLoaderClass();

    protected String getPropertyFilePath(String name) {
        return this.getResourcePath() + this.getPrefix() + "_" + name + ".properties";
    }

    public final Properties loadPropertyFile(String name) {
        return this.loadPropertyFile(name, false);
    }

    public final Properties loadPropertyFile(String name, boolean silent) {
        Level level = LOGGER.getLevel();
        if (silent) {
            LOGGER.setLevel(Level.OFF);
        }
        Properties properties = this.load(this.getPropertyFilePath(name));
        LOGGER.setLevel(level);
        return properties;
    }

    public boolean useCustomDecorations() {
        return true;
    }

    public boolean supportsCustomAccentColor() {
        return false;
    }

    public boolean supportsCustomSelectionColor() {
        return false;
    }

    public abstract ColorToneRule getColorToneRule();

    public ContrastRule getContrastRule() {
        return ContrastRule.STANDARD;
    }

    public FontSizeRule getFontSizeRule() {
        return this.fontSizeRule;
    }

    public FontPrototype getFontPrototype() {
        return this.fontPrototype;
    }

    public AccentColorRule getAccentColorRule() {
        return this.accentColorRule;
    }

    @Override
    public int compareTo(Theme o) {
        if (o == null) {
            return 1;
        }
        int stringComp = this.getName().compareTo(o.getName());
        int contrastCompare = Boolean.compare(Theme.isHighContrast(this), Theme.isHighContrast(o));
        int toneCompare = Boolean.compare(Theme.isDark(this), Theme.isDark(o));
        if (contrastCompare != 0) {
            return contrastCompare;
        }
        if (toneCompare != 0) {
            return toneCompare;
        }
        return stringComp;
    }

    public Class<? extends Theme> getThemeClass() {
        return this.getClass();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Theme)) {
            return false;
        }
        return this.appearsEqualTo((Theme)o);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.fontSizeRule);
        result = 31 * result + Objects.hashCode(this.accentColorRule);
        result = 31 * result + Objects.hashCode(this.fontPrototype);
        result = 31 * result + this.getThemeClass().hashCode();
        return result;
    }

    public boolean appearsEqualTo(Theme theme) {
        if (theme == null) {
            return false;
        }
        if (!Objects.equals(this.getThemeClass(), theme.getThemeClass())) {
            return false;
        }
        return Objects.equals(this.getAccentColorRule(), theme.getAccentColorRule()) && Objects.equals((Object)this.getColorToneRule(), (Object)theme.getColorToneRule()) && Objects.equals((Object)this.getContrastRule(), (Object)theme.getContrastRule()) && Objects.equals(this.getFontSizeRule(), theme.getFontSizeRule()) && Objects.equals(this.getFontPrototype(), theme.getFontPrototype());
    }
}

