/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.colorchooser;

import com.github.weisj.darklaf.properties.color.DarkColorModel;
import com.github.weisj.darklaf.properties.color.DarkColorModelHSB;
import com.github.weisj.darklaf.properties.color.DarkColorModelHSL;
import com.github.weisj.darklaf.properties.color.DarkColorModelRGB;
import com.github.weisj.darklaf.ui.colorchooser.ColorListener;
import com.github.weisj.darklaf.util.ColorUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ColorTriangle
extends JComponent {
    protected static final double SQRT3 = Math.sqrt(3.0);
    private static final Point2D dummy = new Point2D.Double();
    protected static final AlphaComposite COMPOSITE = AlphaComposite.getInstance(3);
    protected final List<ColorListener> myListeners = new ArrayList<ColorListener>();
    protected Color dropFill;
    protected Color dropBorder;
    protected Color background;
    protected int outerIndicatorRadius;
    protected int innerIndicatorRadius;
    protected Color color;
    protected double hueHSB;
    protected double hueHSL;
    protected double valueHSB;
    protected double saturationHSB;
    protected double saturationHSL;
    protected double lightnessHSL;
    protected double opacity = 1.0;
    protected CircleInfo circleInfo = new CircleInfo();
    protected Shape circleShape;
    protected Shape triangleShape;
    protected AffineTransform triangleInverse;
    protected Shape outerIndicator;
    protected Shape innerIndicator;
    protected double centerX;
    protected double centerY;
    protected double outerRadius;
    protected double innerRadius;
    protected double rotation;
    protected PickResult lastPick;
    protected int minSize = 300;
    protected boolean isMessaging;
    protected boolean invalid;
    private boolean isHSB = true;

    public ColorTriangle() {
        this.setOpaque(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ColorTriangle.this.invalid = true;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ColorTriangle.this.setFromPickResult(ColorTriangle.this.pick(e.getX(), e.getY()), true);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ColorTriangle.this.lastPick = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (ColorTriangle.this.lastPick != null && ColorTriangle.this.lastPick.area != PickArea.OUTSIDE) {
                    ColorTriangle.this.setFromPickResult(ColorTriangle.this.pick(e.getX(), e.getY()), false);
                }
            }
        });
        this.updateDefaults();
    }

    protected void updateDefaults() {
        this.background = UIManager.getColor("ColorChooser.colorWheelBackground");
        this.dropFill = UIManager.getColor("ColorChooser.colorWheelDropBackgroundColor");
        if (this.dropFill == null) {
            this.dropFill = UIManager.getColor("Label.background");
        }
        this.dropBorder = UIManager.getColor("ColorChooser.colorWheelDropBorderColor");
        if (this.dropBorder == null) {
            this.dropBorder = UIManager.getColor("Label.foreground");
        }
        this.outerIndicatorRadius = UIManager.getInt("ColorChooser.outerIndicatorRadius");
        if (this.outerIndicatorRadius == 0) {
            this.outerIndicatorRadius = 3;
        }
        this.innerIndicatorRadius = UIManager.getInt("ColorChooser.innerIndicatorRadius");
        if (this.innerIndicatorRadius == 0) {
            this.innerIndicatorRadius = 3;
        }
    }

    protected double getHue() {
        return this.isHSB ? this.getHSBHue() : this.getHSLHue();
    }

    protected double getHSBHue() {
        return this.hueHSB;
    }

    protected double getHSLHue() {
        return this.hueHSL;
    }

    protected double getSaturation() {
        return this.isHSB ? this.getHSBSaturation() : this.getHSLSaturation();
    }

    protected double getHSBSaturation() {
        return this.saturationHSB;
    }

    protected double getHSLSaturation() {
        return this.saturationHSL;
    }

    protected double getValue() {
        return this.isHSB ? this.getHSBValue() : this.getHSLValue();
    }

    protected double getHSBValue() {
        return this.valueHSB;
    }

    protected double getHSLValue() {
        return this.lightnessHSL;
    }

    protected void setHue(double hue) {
        if (this.isHSB) {
            this.setHSBHue(hue);
        } else {
            this.setHSLHue(hue);
        }
    }

    protected void setHSBHue(double hue) {
        this.hueHSB = hue;
        if (this.hueHSB < 0.0) {
            this.hueHSB += 1.0;
        }
    }

    protected void setHSLHue(double hue) {
        this.hueHSL = hue;
        if (this.hueHSL < 0.0) {
            this.hueHSL += 1.0;
        }
    }

    protected void setValue(double value) {
        if (this.isHSB) {
            this.setHSBValue(value);
        } else {
            this.setHSLValue(value);
        }
    }

    protected void setHSBValue(double value) {
        this.valueHSB = value;
    }

    protected void setHSLValue(double value) {
        this.lightnessHSL = value;
    }

    protected void setSaturation(double saturation) {
        if (this.isHSB) {
            this.setHSBSaturation(saturation);
        } else {
            this.setHSLSaturation(saturation);
        }
    }

    protected void setHSBSaturation(double saturation) {
        this.saturationHSB = saturation;
    }

    protected void setHSLSaturation(double saturation) {
        this.saturationHSL = saturation;
    }

    protected void setFromPickResult(PickResult res, boolean updateLastPick) {
        if (updateLastPick) {
            this.lastPick = res;
        }
        if (this.lastPick != null) {
            if (this.lastPick.area == PickArea.WHEEL) {
                this.setHue(res.hue);
                this.rotation = res.rotation;
                this.syncValues();
                this.invalidateWheel();
                this.fireColorChanged(this);
            } else if (this.lastPick.area == PickArea.TRIANGLE) {
                this.setValue(res.value);
                this.setSaturation(res.saturation);
                this.syncValues();
                this.invalidateWheel();
                this.fireColorChanged(this);
            }
        }
    }

    protected void setHSB(double[] hsb) {
        this.setHSB(hsb[0], hsb[1], hsb[2]);
    }

    protected void setHSB(double h, double s, double b) {
        this.setHSBHue(h);
        this.setHSBSaturation(s);
        this.setHSBValue(b);
    }

    protected void setHSL(double[] hsl) {
        this.setHSL(hsl[0], hsl[1], hsl[2]);
    }

    protected void setHSL(double h, double s, double l) {
        this.setHSLHue(h);
        this.setHSLSaturation(s);
        this.setHSLValue(l);
    }

    protected int getColorRGB(double h, double s, double v) {
        if (this.isHSB) {
            return Color.HSBtoRGB((float)h, (float)s, (float)v);
        }
        return DarkColorModelHSL.getColorFromHSLValues(h, s, v).getRGB();
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public int[] getValuesForModel(DarkColorModel model) {
        if (model instanceof DarkColorModelHSB) {
            return new int[]{(int)Math.round(this.getHue() * (double)model.getMaximum(0)), (int)Math.round(this.getHSBSaturation() * (double)model.getMaximum(1)), (int)Math.round(this.getHSBValue() * (double)model.getMaximum(2))};
        }
        if (model instanceof DarkColorModelHSL) {
            return new int[]{(int)Math.round(this.getHue() * (double)model.getMaximum(0)), (int)Math.round(this.getHSLSaturation() * (double)model.getMaximum(1)), (int)Math.round(this.getHSLValue() * (double)model.getMaximum(2))};
        }
        return model.getValuesFromColor(this.color);
    }

    public void setColorFromModel(Object source, DarkColorModel model, int[] values) {
        double x = (double)values[0] / (double)model.getMaximum(0);
        double y = (double)values[1] / (double)model.getMaximum(1);
        double z = (double)values[2] / (double)model.getMaximum(2);
        if (model instanceof DarkColorModelHSB) {
            this.setColorFromHSB(source, x, y, z);
        } else if (model instanceof DarkColorModelHSL) {
            this.setColorFromHSL(source, x, y, z);
        } else if (model instanceof DarkColorModelRGB) {
            this.setColorFromRGB(source, values[0], values[1], values[2]);
        } else {
            this.setColor(source, model.getColorFromValues(values));
        }
    }

    public void setColor(Object source, Color color) {
        Color c = color != null ? color : Color.BLACK;
        this.setColorFromRGB(source, c.getRed(), c.getGreen(), c.getBlue());
    }

    protected void setColorFromRGB(Object source, int r, int g, int b) {
        if (this.isMessaging) {
            return;
        }
        this.color = new Color(r, g, b);
        double[] hsb = DarkColorModelHSB.RGBtoHSBValues(r, g, b);
        double[] hsl = DarkColorModelHSL.RGBtoHSLValues(r, g, b);
        if (Color.getHSBColor((float)this.getHSBHue(), (float)hsb[1], (float)hsb[2]).equals(this.color)) {
            hsb[0] = this.getHSBHue();
            hsl[0] = this.getHSLHue();
        }
        this.setHSL(hsl);
        this.setHSB(hsb);
        this.rotation = -(this.getHue() * 2.0 * Math.PI) + 1.5707963267948966;
        this.invalidateWheel();
        this.fireColorChanged(source);
    }

    protected void setColorFromHSL(Object source, double h, double s, double l) {
        if (this.isMessaging) {
            return;
        }
        this.setHSL(h, s, l);
        this.color = DarkColorModelHSL.getColorFromHSLValues(h, s, l);
        this.setHSB(DarkColorModelHSB.RGBtoHSBValues(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        this.setHSBHue(h);
        this.rotation = -(this.getHue() * 2.0 * Math.PI) + 1.5707963267948966;
        this.invalidateWheel();
        this.fireColorChanged(source);
    }

    protected void setColorFromHSB(Object source, double h, double s, double b) {
        if (this.isMessaging) {
            return;
        }
        this.setHSB(h, s, b);
        this.color = DarkColorModelHSB.getColorFromHSBValues(h, s, b);
        this.setHSL(DarkColorModelHSL.RGBtoHSLValues(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        this.setHSLHue(h);
        this.rotation = -(this.getHue() * 2.0 * Math.PI) + 1.5707963267948966;
        this.invalidateWheel();
        this.fireColorChanged(source);
    }

    protected void invalidateWheel() {
        this.invalid = true;
        Container parent = this.getParent();
        if (parent != null) {
            parent.repaint();
        } else {
            this.repaint();
        }
    }

    protected void syncValues() {
        if (this.isHSB) {
            this.color = Color.getHSBColor((float)this.getHSBHue(), (float)this.getHSBSaturation(), (float)this.getHSBValue());
            this.setHSL(DarkColorModelHSL.RGBtoHSLValues(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        } else {
            this.color = DarkColorModelHSL.getColorFromHSLValues(this.getHSLHue(), this.getHSLSaturation(), this.getHSLValue());
            this.setHSB(DarkColorModelHSB.RGBtoHSBValues(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        }
    }

    protected void fireColorChanged(Object source) {
        this.isMessaging = true;
        Color notifyColor = ColorUtil.toAlpha(this.color, this.opacity);
        for (ColorListener listener : this.myListeners) {
            listener.colorChanged(notifyColor, source);
        }
        this.isMessaging = false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateDefaults();
    }

    protected PickResult pick(double x, double y) {
        Point2D p = dummy;
        p.setLocation(x, y);
        double rotation = ColorTriangle.getRotation(x, y, this.centerX, this.centerY);
        double hue = 0.25 - rotation / (Math.PI * 2);
        this.triangleInverse.transform(p, p);
        Point2D sv = this.getSaturationAndValue(p.getX(), p.getY());
        PickArea area = PickArea.OUTSIDE;
        if (this.triangleShape.contains(x, y) || this.innerIndicator.contains(x, y)) {
            area = PickArea.TRIANGLE;
        } else if (this.circleShape.contains(x, y) || this.outerIndicator.contains(x, y)) {
            area = PickArea.WHEEL;
        }
        return new PickResult(area, rotation, hue, sv.getX(), sv.getY());
    }

    protected Point2D getSaturationAndValue(double x, double y) {
        double x1 = (x - this.centerX) / this.innerRadius;
        double y1 = (y - this.centerY) / this.innerRadius;
        double sat = (1.0 - 2.0 * y1) / (SQRT3 * x1 - y1 + 2.0);
        double val = (SQRT3 * x1 - y1 + 2.0) / 3.0;
        return new Point2D.Double(Math.max(Math.min(sat, 1.0), 0.0), Math.max(Math.min(val, 1.0), 0.0));
    }

    protected static double getRotation(double x, double y, double cx, double cy) {
        return Math.PI - Math.atan2(x - cx, y - cy);
    }

    protected static double getWheelHue(double x, double y, double cx, double cy) {
        return (Math.atan2(x - cx, y - cy) - 1.5707963267948966) / (Math.PI * 2);
    }

    @Override
    public void paint(Graphics g) {
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        Graphics2D g2d = (Graphics2D)g;
        Dimension dim = this.getSize();
        int size = Math.min(dim.width, dim.height);
        size = Math.min(size, 600);
        float x = (float)((double)(dim.width - size) / 2.0);
        float y = (float)((double)(dim.height - size) / 2.0);
        this.centerX = (double)x + (double)size / 2.0;
        this.centerY = (double)y + (double)size / 2.0;
        if (this.invalid || this.circleShape == null || this.triangleShape == null || this.outerIndicator == null) {
            this.createShapes(x, y, size);
        }
        g2d.setComposite(COMPOSITE.derive((float)this.opacity));
        g2d.setPaint(new InnerPaint());
        g2d.fill(this.triangleShape);
        g2d.setPaint(new OuterPaint());
        g2d.fill(this.circleShape);
        context.restoreComposite();
        this.drawIndicator(g2d, this.outerIndicator);
        this.drawIndicator(g2d, this.innerIndicator);
    }

    public void createShapes(float x, float y, int size) {
        int outerSize = 15;
        AffineTransform rotationTransform = AffineTransform.getRotateInstance(this.rotation, this.centerX, this.centerY);
        this.circleShape = this.calculateCircleShape(x, y, size, outerSize);
        this.triangleShape = this.calculateTriangleShape(x, y, size, outerSize, rotationTransform);
        this.outerIndicator = this.createOuterIndicator(this.centerX, this.centerY, (this.innerRadius + this.outerRadius) / 2.0, rotationTransform, this.outerIndicatorRadius);
        this.innerIndicator = this.createInnerIndicator(rotationTransform, this.innerIndicatorRadius);
        this.invalid = false;
        try {
            this.triangleInverse = rotationTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException("Shouldn't happen", e);
        }
    }

    protected void drawIndicator(Graphics2D g, Shape indicator) {
        Stroke old = g.getStroke();
        g.setStroke(new BasicStroke(3.0f));
        g.setColor(this.dropBorder);
        g.draw(indicator);
        g.setStroke(old);
        g.setColor(this.dropFill);
        g.draw(indicator);
    }

    protected Shape createInnerIndicator(AffineTransform transform, int dotRadius) {
        Point2D p = this.getTrianglePos(this.getSaturation(), this.getValue());
        transform.transform(p, p);
        return this.createIndicatorShape(p, dotRadius);
    }

    protected Shape createOuterIndicator(double cx, double cy, double radius, AffineTransform transform, int dotRadius) {
        dummy.setLocation(cx, cy - radius);
        transform.transform(dummy, dummy);
        return this.createIndicatorShape(dummy, dotRadius);
    }

    protected Shape createIndicatorShape(Point2D p, int radius) {
        return new Ellipse2D.Double(p.getX() - (double)radius, p.getY() - (double)radius, 2 * radius, 2 * radius);
    }

    protected Shape calculateTriangleShape(double x, double y, int size, int outerSize, AffineTransform transform) {
        double diameter = size - 2 * outerSize;
        double radius = diameter / 2.0;
        double sideLength = Math.cos(0.5235987755982988) * diameter;
        double height = SQRT3 / 2.0 * sideLength;
        double upperX = radius + x + (double)outerSize;
        double upperY = y + (double)outerSize;
        Path2D.Float trianglePath = new Path2D.Float(0);
        ((Path2D)trianglePath).moveTo(upperX, upperY);
        ((Path2D)trianglePath).lineTo(upperX - sideLength / 2.0, upperY + height);
        ((Path2D)trianglePath).lineTo(upperX + sideLength / 2.0, upperY + height);
        trianglePath.closePath();
        ((Path2D)trianglePath).transform(transform);
        return trianglePath;
    }

    protected Shape calculateCircleShape(double x, double y, int size, int outerSize) {
        this.outerRadius = (double)size / 2.0;
        this.innerRadius = this.outerRadius - (double)outerSize;
        if (!this.circleInfo.update(x, y, size, outerSize) && this.circleShape != null) {
            return this.circleShape;
        }
        Area outer = new Area(new Ellipse2D.Double(x, y, size, size));
        Area inner = new Area(new Ellipse2D.Double(x + (double)outerSize, y + (double)outerSize, size - 2 * outerSize, size - 2 * outerSize));
        outer.subtract(inner);
        return outer;
    }

    protected Point2D getTrianglePos(double sat, double val) {
        return new Point2D.Double(this.centerX + this.innerRadius * (2.0 * val - sat * val - 1.0) * SQRT3 / 2.0, this.centerY + this.innerRadius * (1.0 - 3.0 * sat * val) / 2.0);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minSize, this.minSize);
    }

    public void setMinimumSize(int size) {
        this.minSize = size;
    }

    public void addListener(ColorListener listener) {
        this.myListeners.add(listener);
    }

    public Color getColor() {
        return ColorUtil.toAlpha(this.color, this.opacity);
    }

    public void setColorModel(DarkColorModel model) {
        boolean hsb;
        boolean bl = hsb = !(model instanceof DarkColorModelHSL);
        if (this.isHSB != hsb) {
            this.isHSB = hsb;
            this.invalidateWheel();
        }
    }

    protected static class CircleInfo {
        public double x;
        public double y;
        public int size;
        public int outerSize;

        protected CircleInfo() {
        }

        public boolean update(double x, double y, int size, int outerSize) {
            boolean updated = this.x != x || this.y != y || this.size != size || this.outerSize != outerSize;
            this.x = x;
            this.y = y;
            this.size = size;
            this.outerSize = outerSize;
            return updated;
        }
    }

    protected static class PickResult {
        protected final PickArea area;
        protected final double rotation;
        protected final double saturation;
        protected final double value;
        protected final double hue;

        public PickResult(PickArea area, double rotation, double hue, double saturation, double value) {
            this.area = area;
            this.hue = hue;
            this.rotation = rotation;
            this.saturation = saturation;
            this.value = value;
        }
    }

    protected static enum PickArea {
        OUTSIDE,
        WHEEL,
        TRIANGLE;

    }

    protected class InnerPaint
    extends ColorWheelPaint {
        protected InnerPaint() {
            super(new InnerPaintContext());
        }
    }

    protected static class OuterPaint
    extends ColorWheelPaint {
        protected OuterPaint() {
            super(new OuterPaintContext());
        }
    }

    protected class InnerPaintContext
    extends ColorWheelPaintContext {
        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    dummy.setLocation(x + i, y + j);
                    try {
                        this.transform.inverseTransform(dummy, dummy);
                        ColorTriangle.this.triangleInverse.transform(dummy, dummy);
                        Point2D sv = ColorTriangle.this.getSaturationAndValue(dummy.getX(), dummy.getY());
                        this.setPixel(raster, i, j, ColorTriangle.this.getColorRGB(ColorTriangle.this.getHue(), sv.getX(), sv.getY()));
                        continue;
                    }
                    catch (NoninvertibleTransformException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            return raster;
        }
    }

    protected static class OuterPaintContext
    extends ColorWheelPaintContext {
        protected OuterPaintContext() {
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            for (int j = 0; j < h; ++j) {
                for (int i = 0; i < w; ++i) {
                    float hue = (float)ColorTriangle.getWheelHue(x + i, y + j, this.cx, this.cy);
                    int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                    this.setPixel(raster, i, j, rgb);
                }
            }
            return raster;
        }
    }

    protected static abstract class ColorWheelPaintContext
    implements PaintContext {
        protected Rectangle deviceBounds;
        protected double cx;
        protected double cy;
        protected AffineTransform transform;

        protected ColorWheelPaintContext() {
        }

        public void setHints(Rectangle deviceBounds, AffineTransform transform) {
            this.deviceBounds = deviceBounds;
            this.cx = (double)deviceBounds.x + (double)deviceBounds.width / 2.0;
            this.cy = (double)deviceBounds.y + (double)deviceBounds.height / 2.0;
            this.transform = transform;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        protected void setPixel(WritableRaster raster, int i, int j, int rgb) {
            this.setPixel(raster, i, j, new int[]{rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, 255});
        }

        protected void setPixel(WritableRaster raster, int i, int j, int[] vals) {
            raster.setPixel(i, j, vals);
        }
    }

    public static abstract class ColorWheelPaint
    implements Paint {
        protected final ColorWheelPaintContext context;

        protected ColorWheelPaint(ColorWheelPaintContext context) {
            this.context = context;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            this.context.setHints(deviceBounds, xform);
            return this.context;
        }

        @Override
        public int getTransparency() {
            return 1;
        }
    }
}

