/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.cell.hint.AbstractIndexedCellContainer;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;

public class TableCellContainer
extends AbstractIndexedCellContainer<JTable, Pair<Integer, Integer>, DarkTableUI> {
    private final JTable table;

    public TableCellContainer(JTable table, DarkTableUI ui) {
        super(ui);
        this.table = table;
    }

    @Override
    public Rectangle getCellBoundsAt(Pair<Integer, Integer> position, boolean isEditing) {
        return isEditing ? this.table.getEditorComponent().getBounds() : this.table.getCellRect(position.getFirst(), position.getSecond(), false);
    }

    @Override
    public Pair<Integer, Integer> getCellPosition(Point p) {
        return new Pair<Integer, Integer>(this.table.rowAtPoint(p), this.table.columnAtPoint(p));
    }

    @Override
    public JTable getComponent() {
        return this.table;
    }

    @Override
    public boolean isEditing() {
        return this.table.isEditing();
    }

    @Override
    public Color getBackgroundAt(Pair<Integer, Integer> position, Component renderer) {
        return renderer.getBackground();
    }

    @Override
    public boolean isEditingCell(Pair<Integer, Integer> position) {
        return this.isEditing() && position != null && this.table.getEditingColumn() == position.getSecond().intValue() && this.table.getEditingRow() == position.getFirst().intValue();
    }

    @Override
    public Component getCellRendererComponent(Pair<Integer, Integer> position) {
        if (position == null) {
            return null;
        }
        int row = position.getFirst();
        int column = position.getSecond();
        boolean isSelected = this.table.isCellSelected(row, column);
        Object value = this.table.getValueAt(row, column);
        boolean focus = this.table.hasFocus();
        return ((DarkTableUI)this.ui).getCellRenderer(row, column).getTableCellRendererComponent(this.table, value, isSelected, focus, row, column);
    }

    @Override
    public Component getCellEditorComponent(Pair<Integer, Integer> position) {
        return this.table.getEditorComponent();
    }
}

