/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellBorder;
import com.github.weisj.darklaf.ui.table.DarkTableCellBorder;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TextTableCellEditorBorder
extends DarkCellBorder {
    protected final Color borderColor;
    private final Border base = new DarkTableCellBorder();

    public TextTableCellEditorBorder() {
        this.borderColor = UIManager.getColor("TextField.border.enabled");
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.borderColor);
        JTable table = this.getTable(c);
        if (table != null) {
            CellUtil.paintTableEditorBorder(g, c, table, width, height);
        } else {
            PaintUtil.drawRect(g, x, y, width, height, 1);
        }
    }

    private JTable getTable(Component c) {
        return DarkUIUtil.getParentOfType(JTable.class, c, 3);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return CellUtil.adjustEditorInsets(this.base.getBorderInsets(c), c, this.getTable(c));
    }
}

