/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.togglebutton;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;

public class ButtonGroupInfo {
    protected final AbstractButton activeButton;
    protected AbstractButton firstButton = null;
    protected AbstractButton lastButton = null;
    protected AbstractButton previousButton = null;
    protected AbstractButton nextButton = null;
    protected final HashSet<AbstractButton> buttonsInGroup;
    protected boolean sourceFound = false;

    public ButtonGroupInfo(AbstractButton btn) {
        this.activeButton = btn;
        this.buttonsInGroup = new HashSet();
    }

    public static boolean isValidButton(Object obj) {
        return obj instanceof AbstractButton && ((AbstractButton)obj).isEnabled() && ((AbstractButton)obj).isVisible();
    }

    protected boolean containsInGroup(AbstractButton button) {
        return this.buttonsInGroup.contains(button);
    }

    protected Component getFocusTransferBaseComponent(boolean next) {
        return this.firstButton;
    }

    protected boolean getButtonGroupInfo() {
        if (this.activeButton == null) {
            return false;
        }
        this.buttonsInGroup.clear();
        ButtonModel model = this.activeButton.getModel();
        if (!(model instanceof DefaultButtonModel)) {
            return false;
        }
        DefaultButtonModel bm = (DefaultButtonModel)model;
        ButtonGroup group = bm.getGroup();
        if (group == null) {
            return false;
        }
        Enumeration<AbstractButton> e = group.getElements();
        if (e == null) {
            return false;
        }
        while (e.hasMoreElements()) {
            AbstractButton curElement = e.nextElement();
            if (!ButtonGroupInfo.isValidButton(curElement)) continue;
            this.buttonsInGroup.add(curElement);
            if (this.firstButton == null) {
                this.firstButton = curElement;
            }
            if (this.activeButton == curElement) {
                this.sourceFound = true;
            } else if (!this.sourceFound) {
                this.previousButton = curElement;
            } else if (this.nextButton == null) {
                this.nextButton = curElement;
            }
            this.lastButton = curElement;
        }
        return true;
    }

    protected void selectNewButton(boolean next) {
        if (!this.getButtonGroupInfo()) {
            return;
        }
        if (this.sourceFound) {
            AbstractButton newSelectedButton;
            if (next) {
                newSelectedButton = null == this.nextButton ? this.firstButton : this.nextButton;
            } else {
                AbstractButton abstractButton = newSelectedButton = null == this.previousButton ? this.lastButton : this.previousButton;
            }
            if (newSelectedButton != null && newSelectedButton != this.activeButton) {
                newSelectedButton.requestFocusInWindow();
            }
        }
    }

    protected void jumpToNextComponent(boolean next) {
        Component focusBase;
        if (!this.getButtonGroupInfo()) {
            if (this.activeButton != null) {
                this.lastButton = this.activeButton;
                this.firstButton = this.activeButton;
            } else {
                return;
            }
        }
        if ((focusBase = this.getFocusTransferBaseComponent(next)) != null) {
            if (next) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(focusBase);
            } else {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(focusBase);
            }
        }
    }
}

