/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.nodes.filter.Filter;
import com.github.weisj.jsvg.nodes.filter.FilterContext;
import com.github.weisj.jsvg.nodes.filter.FilterPrimitive;
import com.github.weisj.jsvg.nodes.filter.ImageProducerChannel;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.FilterPrimitive})
@PermittedContent(anyOf={})
public class FeFlood
extends FilterPrimitive {
    public static final String TAG = "feflood";
    private SVGPaint floodColor;
    private float floodOpacity;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.floodColor = attributeNode.getPaint("flood-color");
        this.floodOpacity = attributeNode.getPercentage("flood-opacity", 1.0f);
    }

    @Override
    public void applyFilter(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull FilterContext filterContext) {
        Filter.FilterInfo info = filterContext.info();
        BufferedImage img = new BufferedImage(info.imageWidth, info.imageHeight, 2);
        Graphics2D graphics = (Graphics2D)img.getGraphics();
        graphics.setComposite(AlphaComposite.Src.derive(this.floodOpacity));
        Rectangle rect = new Rectangle(0, 0, img.getWidth(), img.getHeight());
        this.floodColor.fillShape(graphics, context.measureContext(), rect, rect);
        graphics.dispose();
        this.saveResult(new ImageProducerChannel(img.getSource()), filterContext);
    }
}

