/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.eigenraven.lwjgl3ify.relauncher.Relauncher;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public final class JvmLocator {
    private static final boolean IS_UNIXY = !SystemUtils.IS_OS_WINDOWS;
    private static final Function<Path, Path> BIN_JAVA_RESOLVER = IS_UNIXY ? p -> p.resolve("bin").resolve("java") : p -> p.resolve("bin").resolve("javaw.exe");
    private static final Pattern OSX_INSTALLATION_PATTERN = Pattern.compile(".+\\s+(/.+)");

    private JvmLocator() {
    }

    public static List<Path> detectJavaInstalls(List<String> cache) {
        ArrayList<Path> out = new ArrayList<Path>();
        for (String cacheEntry : cache) {
            Path p = Paths.get(cacheEntry, new String[0]);
            if (!Files.isRegularFile(p, new LinkOption[0])) continue;
            out.add(p);
        }
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_FREE_BSD) {
            try {
                JvmLocator.searchLinuxDirs(out);
            }
            catch (Throwable t) {
                Relauncher.logger.warn("Could not scan JVM homes", t);
            }
        }
        if (SystemUtils.IS_OS_MAC) {
            try {
                JvmLocator.searchMacJavaHomes(out);
            }
            catch (Throwable t) {
                Relauncher.logger.warn("Could not scan JVM homes", t);
            }
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                JvmLocator.searchWindowsRegistry(out);
            }
            catch (Throwable t) {
                Relauncher.logger.warn("Could not scan JVM homes", t);
            }
        }
        Collections.sort(out);
        return Lists.newArrayList((Iterable)Sets.newLinkedHashSet(out));
    }

    private static void searchDirs(List<Path> out, String ... dirs) {
        for (String dir : dirs) {
            Path path = Paths.get(dir, new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            Path simpleChild = BIN_JAVA_RESOLVER.apply(path);
            if (Files.isRegularFile(simpleChild, new LinkOption[0])) {
                out.add(simpleChild);
            }
            try (Stream<Path> children = Files.list(path);){
                children.forEach(child -> {
                    Path binJava = BIN_JAVA_RESOLVER.apply((Path)child);
                    if (Files.isRegularFile(binJava, new LinkOption[0])) {
                        out.add(binJava);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void searchLinuxDirs(List<Path> out) {
        JvmLocator.searchDirs(out, "/usr/lib/jvm", "/usr/lib/java", "/usr/java", "/usr/local/java", "/opt/java");
        if (!Files.isSymbolicLink(Paths.get("/usr/lib64", new String[0]))) {
            JvmLocator.searchDirs(out, "/usr/lib64/jvm", "/usr/lib64/java");
        }
    }

    private static void searchMacJavaHomes(List<Path> out) {
        String[] cmdOut;
        for (String outLine : cmdOut = JvmLocator.getProcessOutput("/usr/libexec/java_home", "-V").split("\n")) {
            String javaHome;
            Path binJava;
            Matcher matcher = OSX_INSTALLATION_PATTERN.matcher(outLine);
            if (!matcher.matches() || !Files.isRegularFile(binJava = BIN_JAVA_RESOLVER.apply(Paths.get(javaHome = matcher.group(1), new String[0])), new LinkOption[0])) continue;
            out.add(binJava);
        }
    }

    private static void searchWindowsRegistry(List<Path> out) {
        ArrayList javaHomes = new ArrayList();
        Stream.of("SOFTWARE\\AdoptOpenJDK\\JDK", "SOFTWARE\\Eclipse Adoptium\\JDK", "SOFTWARE\\Eclipse Foundation\\JDK").forEach(p -> javaHomes.addAll(JvmLocator.scanRegistryJvms(p, "\\hotspot\\MSI", "Path")));
        Stream.of("SOFTWARE\\JavaSoft\\JDK", "SOFTWARE\\JavaSoft\\Java Development Kit", "SOFTWARE\\JavaSoft\\Java Runtime Environment", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Development Kit", "SOFTWARE\\Wow6432Node\\JavaSoft\\Java Runtime Environment").forEach(p -> javaHomes.addAll(JvmLocator.scanRegistryJvms(p, "", "JavaHome")));
        for (String javaHome : javaHomes) {
            Path binJava = BIN_JAVA_RESOLVER.apply(Paths.get(javaHome, new String[0]));
            if (!Files.isRegularFile(binJava, new LinkOption[0])) continue;
            out.add(binJava);
        }
    }

    private static List<String> scanRegistryJvms(String sdkSubkey, String path, String value) {
        return JvmLocator.getRegistrySubkeys("HKLM\\" + sdkSubkey).stream().map(withVersion -> JvmLocator.getRegistryKey(withVersion + path, value)).collect(Collectors.toList());
    }

    private static String getRegistryKey(String location, String key) {
        String out = JvmLocator.getProcessOutput("REG.EXE", "QUERY", location, "/v", key);
        if (out.isEmpty()) {
            return null;
        }
        if (!out.contains(key)) {
            return null;
        }
        for (String line : out.split("\n")) {
            if ((line = line.trim()).isEmpty() || !line.startsWith(key)) continue;
            line = line.substring(key.length()).trim();
            String firstWord = line.split("\\s+")[0];
            line = line.substring(firstWord.length()).trim();
            return line;
        }
        return null;
    }

    private static List<String> getRegistrySubkeys(String location) {
        String out = JvmLocator.getProcessOutput("REG.EXE", "QUERY", location);
        if (out.isEmpty()) {
            return Collections.emptyList();
        }
        String sublocationPrefix = location + '\\';
        if (!out.contains(sublocationPrefix)) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (String line : out.split("\n")) {
            if ((line = line.trim()).isEmpty() || !line.startsWith(sublocationPrefix)) continue;
            ret.add(line);
        }
        return ret;
    }

    private static String getProcessOutput(String ... cmd) {
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE);
            pb.environment().remove("JAVA_VERSION");
            Process p = pb.start();
            String stdout = IOUtils.toString((InputStream)p.getInputStream()) + "\n" + IOUtils.toString((InputStream)p.getErrorStream());
            int ec = p.waitFor();
            if (ec != 0) {
                return "";
            }
            return stdout.trim();
        }
        catch (IOException | InterruptedException e) {
            return "";
        }
    }
}

