/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryEvent;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.message.OpenInventoryMessage;
import net.malisis.core.inventory.player.PlayerInventory;
import net.malisis.core.util.EntityUtils;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class MalisisInventory
implements IInventory {
    protected Set<MalisisInventoryContainer> containers = Collections.newSetFromMap(new WeakHashMap());
    protected int inventoryId;
    protected IInventoryProvider inventoryProvider;
    protected ItemStack itemStackProvider;
    protected MalisisSlot[] slots;
    protected String name;
    protected int size;
    protected int slotMaxStackSize = 64;
    private EventBus bus = new EventBus();
    public InventoryState state = new InventoryState();

    public MalisisInventory(IInventoryProvider provider, int size) {
        this.inventoryProvider = provider;
        MalisisSlot[] slots = new MalisisSlot[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = new MalisisSlot(this, i);
        }
        this.setSlots(slots);
    }

    public MalisisInventory(IInventoryProvider provider, MalisisSlot[] slots) {
        this.inventoryProvider = provider;
        this.setSlots(slots);
    }

    public IInventoryProvider getProvider() {
        return this.inventoryProvider;
    }

    public void setSlots(MalisisSlot[] slots) {
        this.size = slots.length;
        this.slots = slots;
        for (MalisisSlot slot : slots) {
            slot.setInventory(this);
        }
    }

    public void overrideSlot(MalisisSlot slot, int slotNumber) {
        if (slotNumber < 0 || slotNumber >= this.func_70302_i_()) {
            return;
        }
        this.slots[slotNumber] = slot;
        slot.setInventory(this);
    }

    public void register(Object object) {
        this.bus.register(object);
    }

    public void setInventoryId(int id) {
        this.inventoryId = id;
        if (this.itemStackProvider == null) {
            return;
        }
        NBTTagCompound tag = this.itemStackProvider.field_77990_d;
        if (tag == null) {
            this.itemStackProvider.field_77990_d = tag = new NBTTagCompound();
        }
        this.itemStackProvider.field_77990_d.func_74768_a("inventoryId", id);
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String func_145825_b() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name != null;
    }

    public MalisisSlot getSlot(int slotNumber) {
        if (slotNumber < 0 || slotNumber >= this.func_70302_i_()) {
            return null;
        }
        return this.slots[slotNumber];
    }

    public MalisisSlot[] getSlots() {
        return this.slots;
    }

    public ItemStack getItemStack(int slotNumber) {
        MalisisSlot slot = this.getSlot(slotNumber);
        return slot != null ? slot.getItemStack() : null;
    }

    public void setItemStack(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getSlot(slotNumber);
        if (slot == null) {
            return;
        }
        if (itemStack != null) {
            int max = Math.min(slot.getSlotStackLimit(), itemStack.func_77976_d());
            itemStack.field_77994_a = Math.min(itemStack.field_77994_a, max);
        }
        if (ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)slot.getItemStack())) {
            return;
        }
        slot.setItemStack(itemStack);
        slot.onSlotChanged();
    }

    public List<ItemStack> getItemStackList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.getItemStack(i) == null) continue;
            list.add(this.getItemStack(i));
        }
        return list;
    }

    public boolean itemValidForSlot(MalisisSlot slot, ItemStack itemStack) {
        return true;
    }

    public boolean func_94041_b(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getSlot(slotNumber);
        if (slot == null) {
            return false;
        }
        return slot.isItemValid(itemStack);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public int func_70297_j_() {
        return this.slotMaxStackSize;
    }

    public void setInventoryStackLimit(int limit) {
        this.slotMaxStackSize = limit;
    }

    public void setItemStackProvider(ItemStack itemStack) {
        if (!(this.inventoryProvider instanceof Item)) {
            throw new IllegalArgumentException("setItemStack not allowed with " + this.inventoryProvider.getClass().getSimpleName() + " provider.");
        }
        if (itemStack.func_77973_b() != this.inventoryProvider) {
            MalisisCore.log.error("[MalisisInventory] Tried to set itemStack with an different item (" + itemStack.func_77973_b() + ") than the provider (" + this.inventoryProvider + ")");
            return;
        }
        this.itemStackProvider = itemStack;
        this.readFromNBT(itemStack.func_77978_p());
    }

    public void addOpenedContainer(MalisisInventoryContainer container) {
        this.containers.add(container);
    }

    public void removeOpenedContainer(MalisisInventoryContainer container) {
        this.containers.remove((Object)container);
        if (this.containers.size() == 0 && this.itemStackProvider != null && this.itemStackProvider.field_77990_d != null) {
            this.itemStackProvider.field_77990_d.func_82580_o("inventoryId");
        }
    }

    public Set<MalisisInventoryContainer> getOpenedContainers() {
        return this.containers;
    }

    public boolean isEmpty() {
        return this.getItemStackList().size() == 0;
    }

    public boolean isFull() {
        for (MalisisSlot slot : this.slots) {
            if (slot.isFull()) continue;
            return false;
        }
        return true;
    }

    public void onSlotChanged(MalisisSlot slot) {
        if (this.inventoryProvider instanceof Item && this.itemStackProvider != null) {
            this.writeToNBT(this.itemStackProvider.func_77978_p());
        }
        this.bus.post((Object)new InventoryEvent.SlotChanged(this, slot));
    }

    public void func_70295_k_() {
    }

    public MalisisSlot getFirstOccupiedSlot() {
        for (MalisisSlot slot : this.slots) {
            if (slot.getItemStack() == null) continue;
            return slot;
        }
        return null;
    }

    public ItemStack pullItemStack() {
        MalisisSlot slot = this.getFirstOccupiedSlot();
        if (slot == null) {
            return null;
        }
        ItemStack itemStack = slot.getItemStack();
        slot.setItemStack(null);
        slot.onSlotChanged();
        return itemStack;
    }

    public ItemStack transferInto(ItemStack itemStack) {
        return this.transferInto(itemStack, false);
    }

    public ItemStack transferInto(ItemStack itemStack, boolean reversed) {
        int end;
        int start = reversed ? this.size - 1 : 0;
        if ((itemStack = this.transferInto(itemStack, false, start, end = reversed ? 0 : this.size - 1)) != null) {
            itemStack = this.transferInto(itemStack, true, start, end);
        }
        return itemStack;
    }

    protected ItemStack transferInto(ItemStack itemStack, boolean emptySlot, int start, int end) {
        int current = start;
        int step = 1;
        if (start > end) {
            step = -1;
            start = end;
            end = current;
        }
        while (itemStack != null && current >= start && current <= end) {
            MalisisSlot slot = this.getSlot(current);
            if (slot.isItemValid(itemStack) && !slot.isOutputSlot() && (emptySlot || slot.getItemStack() != null)) {
                itemStack = slot.insert(itemStack);
            }
            current += step;
        }
        return itemStack;
    }

    public void breakInventory(World world, int x, int y, int z) {
        for (ItemStack itemStack : this.getItemStackList()) {
            EntityUtils.spawnEjectedItem(world, x, y, z, itemStack);
        }
        this.closeContainers();
    }

    public void closeContainers() {
        for (MalisisInventoryContainer container : this.containers) {
            container.close();
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound stackTag = nbttaglist.func_150305_b(i);
            int slotNumber = stackTag.func_74771_c("Slot") & 0xFF;
            MalisisSlot slot = this.getSlot(slotNumber);
            if (slot == null) continue;
            slot.setItemStack(ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.getItemStack(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Items", (NBTBase)itemList);
    }

    public String toString() {
        String provider = "Player";
        if (!(this instanceof PlayerInventory)) {
            provider = this.inventoryProvider != null ? this.inventoryProvider.getClass().getSimpleName() : "null\t";
        }
        return (this.name != null ? this.name : this.getClass().getSimpleName()) + " (" + this.inventoryId + ") from " + provider;
    }

    public static MalisisInventoryContainer open(EntityPlayerMP player, IInventoryProvider inventoryProvider, Object ... data) {
        if (inventoryProvider == null) {
            return null;
        }
        MalisisInventoryContainer c = new MalisisInventoryContainer((EntityPlayer)player, 0);
        MalisisInventory[] inventories = inventoryProvider.getInventories(data);
        if (inventories != null) {
            for (MalisisInventory inv : inventories) {
                c.addInventory(inv);
                inv.func_70295_k_();
                inv.bus.post((Object)new InventoryEvent.Open(c, inv));
            }
        }
        OpenInventoryMessage.send(inventoryProvider, player, c.field_75152_c);
        c.sendInventoryContent();
        return c;
    }

    @SideOnly(value=Side.CLIENT)
    public static MalisisInventoryContainer open(EntityClientPlayerMP player, IInventoryProvider inventoryProvider, int windowId, Object ... data) {
        MalisisGui gui;
        if (inventoryProvider == null) {
            return null;
        }
        MalisisInventoryContainer c = new MalisisInventoryContainer((EntityPlayer)player, windowId);
        MalisisInventory[] inventories = inventoryProvider.getInventories(data);
        if (inventories != null) {
            for (MalisisInventory inv : inventories) {
                c.addInventory(inv);
                inv.func_70295_k_();
                inv.bus.post((Object)new InventoryEvent.Open(c, inv));
            }
        }
        if (FMLCommonHandler.instance().getSide().isClient() && (gui = inventoryProvider.getGui(c)) != null) {
            gui.display();
        }
        return c;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
    }

    public ItemStack func_70298_a(int slot, int count) {
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Deprecated
    public ItemStack func_70301_a(int slotNumber) {
        return this.getItemStack(slotNumber);
    }

    @Deprecated
    public void func_70299_a(int slotNumber, ItemStack itemStack) {
        this.setItemStack(slotNumber, itemStack);
    }
}

