/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;

public class PositionTransform<T>
extends Transformation<PositionTransform, ITransformable.Position<T>> {
    protected int fromX;
    protected int fromY;
    protected int toX;
    protected int toY;

    public PositionTransform(int fromX, int fromY, int toX, int toY) {
        this.from(fromX, fromY);
        this.to(toX, toY);
    }

    public PositionTransform<T> from(int x, int y) {
        this.fromX = x;
        this.fromY = y;
        return this;
    }

    public PositionTransform<T> to(int x, int y) {
        this.toX = x;
        this.toY = y;
        return this;
    }

    @Override
    protected void doTransform(ITransformable.Position<T> transformable, float comp) {
        int fromX = this.reversed ? this.toX : this.fromX;
        int toX = this.reversed ? this.fromX : this.toX;
        int fromY = this.reversed ? this.toY : this.fromY;
        int toY = this.reversed ? this.fromY : this.toY;
        int x = Math.round((float)fromX + (float)(toX - fromX) * comp);
        int y = Math.round((float)fromY + (float)(toY - fromY) * comp);
        transformable.setPosition(x, y);
    }
}

