/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MergedVertex
implements ITransformable.Translate,
ITransformable.Rotate,
ITransformable.Scale,
ITransformable.Alpha,
ITransformable.Color,
ITransformable.Brightness,
Iterable<Vertex> {
    protected String name;
    protected Vertex base;
    protected Matrix4f transformMatrix = new Matrix4f();
    private final Set<Vertex> vertexes = new HashSet<Vertex>();

    public MergedVertex(Vertex vertex) {
        this.name = vertex.baseName();
        this.base = vertex;
        this.addVertex(vertex);
    }

    public double getX() {
        return this.base.getX();
    }

    public void setX(double x) {
        for (Vertex v : this.vertexes) {
            v.setX(x);
        }
    }

    public double getY() {
        return this.base.getY();
    }

    public void setY(double y) {
        for (Vertex v : this.vertexes) {
            v.setY(y);
        }
    }

    public double getZ() {
        return this.base.getZ();
    }

    public void setZ(double z) {
        for (Vertex v : this.vertexes) {
            v.setZ(z);
        }
    }

    public boolean is(String ... names) {
        boolean b = true;
        for (String n : names) {
            b &= this.name.toLowerCase().contains(n.toLowerCase());
        }
        return b;
    }

    public void addVertex(Vertex vertex) {
        if (!this.name.equals(vertex.baseName())) {
            return;
        }
        this.vertexes.add(vertex);
    }

    public void removeVertex(Vertex vertex) {
        this.vertexes.remove(vertex);
    }

    private void resetMatrix() {
        this.transformMatrix.identity();
        this.transformMatrix.translate(0.5f, 0.5f, 0.5f);
    }

    public void copyMatrix(Matrix4f matrix) {
        this.transformMatrix = new Matrix4f((Matrix4fc)matrix);
    }

    public void applyMatrix() {
        this.transformMatrix.translate(-0.5f, -0.5f, -0.5f);
        for (Vertex v : this.vertexes) {
            v.applyMatrix(this.transformMatrix);
        }
        this.resetMatrix();
    }

    @Override
    public void translate(float x, float y, float z) {
        this.transformMatrix.translate(x, y, z);
    }

    @Override
    public void rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        this.translate(offsetX, offsetY, offsetZ);
        this.transformMatrix.rotate((float)Math.toRadians(angle), x, y, z);
        this.translate(-offsetX, -offsetY, -offsetZ);
    }

    @Override
    public void scale(float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        this.translate(offsetX, offsetY, offsetZ);
        this.transformMatrix.scale(x, y, z);
        this.translate(-offsetX, -offsetY, -offsetZ);
    }

    @Override
    public void setColor(int color) {
        for (Vertex v : this) {
            v.setColor(color);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        for (Vertex v : this) {
            v.setAlpha(alpha);
        }
    }

    @Override
    public void setBrightness(int brightness) {
        for (Vertex v : this) {
            v.setBrightness(brightness);
        }
    }

    @Override
    public Iterator<Vertex> iterator() {
        return this.vertexes.iterator();
    }

    public static Map<String, MergedVertex> getMergedVertexes(Shape shape) {
        HashMap<String, MergedVertex> mergedVertexes = new HashMap<String, MergedVertex>();
        for (Face f : shape.getFaces()) {
            for (Vertex v : f.getVertexes()) {
                MergedVertex mv = (MergedVertex)mergedVertexes.get(v.baseName());
                if (mv == null) {
                    mv = new MergedVertex(v);
                    mergedVertexes.put(v.baseName(), mv);
                    continue;
                }
                mv.addVertex(v);
            }
        }
        return mergedVertexes;
    }

    public String getName() {
        return this.name;
    }

    public Vertex getBase() {
        return this.base;
    }
}

