/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.tileentity;

import java.util.HashMap;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntitySidedInventory
extends TileEntity
implements IInventoryProvider,
ISidedInventory {
    protected HashMap<ForgeDirection, MalisisInventory> inventories = new HashMap();
    protected HashMap<Integer, ForgeDirection> ranges = new HashMap();
    protected int totalSize = 0;

    protected void addSidedInventory(MalisisInventory inventory, ForgeDirection ... sides) {
        int size = inventory.func_70302_i_();
        this.totalSize += size;
        for (ForgeDirection side : sides) {
            if (this.inventories.get(side) != null) continue;
            this.inventories.put(side, inventory);
            this.ranges.put(this.totalSize, side);
        }
    }

    private int convertSlotNumber(int slotNumber) {
        return slotNumber >> 3;
    }

    public MalisisInventory getInventory(int slotNumber) {
        return this.inventories.get(ForgeDirection.getOrientation((int)(slotNumber & 7)));
    }

    @Override
    public MalisisInventory[] getInventories(Object ... data) {
        return this.inventories.values().toArray(new MalisisInventory[0]);
    }

    @Override
    public MalisisInventory[] getInventories(ForgeDirection side, Object ... data) {
        return new MalisisInventory[]{this.inventories.get(side)};
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public int func_70302_i_() {
        return this.totalSize;
    }

    public ItemStack func_70301_a(int slotNumber) {
        return this.getInventory(slotNumber).getItemStack(slotNumber);
    }

    public ItemStack func_70298_a(int slotNumber, int amount) {
        return new ItemUtils.ItemStackSplitter(this.getInventory(slotNumber).getItemStack(slotNumber)).split(amount);
    }

    public ItemStack func_70304_b(int slotNumber) {
        return this.getInventory(slotNumber).getItemStack(slotNumber);
    }

    public void func_70299_a(int slotNumber, ItemStack itemStack) {
        this.getInventory(slotNumber).setItemStack(slotNumber, itemStack);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotNumber, ItemStack itemStack) {
        MalisisSlot slot = this.getInventory(slotNumber).getSlot(this.convertSlotNumber(slotNumber));
        return slot != null && slot.isItemValid(itemStack);
    }

    public int[] func_94128_d(int side) {
        MalisisInventory inventory = this.inventories.get(ForgeDirection.getOrientation((int)side));
        if (inventory == null) {
            return new int[0];
        }
        int[] a = new int[inventory.func_70302_i_()];
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            a[i] = i << 3 | side;
        }
        return a;
    }

    public boolean func_102007_a(int slotNumber, ItemStack itemStack, int side) {
        MalisisInventory inventory = this.inventories.get(ForgeDirection.getOrientation((int)side));
        return inventory != null && inventory.func_94041_b(this.convertSlotNumber(slotNumber), itemStack);
    }

    public boolean func_102008_b(int slotNumber, ItemStack itemStack, int side) {
        return true;
    }
}

