/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import cpw.mods.fml.client.FMLClientHandler;
import net.malisis.core.util.ShaderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class RenderHelper {
    private static ShaderSystem shaders;
    private static final String REPEAT_SHADER = "#version 120\nuniform sampler2D tex; uniform vec2 iconOffset; uniform vec2 iconSize;\nvoid main() {\ngl_FragColor = texture2D(tex, iconOffset + fract(gl_TexCoord[0].st) * iconSize) * gl_Color;\n}";

    public static void bindTexture(String path) {
        RenderHelper.bindTexture(new ResourceLocation(path));
    }

    public static void bindTexture(ResourceLocation path) {
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(path);
    }

    public static int getColorFromRGB(int r, int g, int b) {
        return 0xFF0000 & r << 16 | 0xFF00 & g << 8 | 0xFF & b;
    }

    public static int getColorFromRGB(Color color) {
        return 0xFF0000 & color.getRed() << 16 | 0xFF00 & color.getGreen() << 8 | 0xFF & color.getBlue();
    }

    public static int getStringWidth(String text) {
        return RenderHelper.getMC().field_71466_p.func_78256_a(text);
    }

    public static String getLongestString(String ... strings) {
        String s = "";
        int longest = 0;
        for (String string : strings) {
            if (longest >= string.length()) continue;
            s = string;
            longest = string.length();
        }
        return s;
    }

    public static Minecraft getMC() {
        return FMLClientHandler.instance().getClient();
    }

    public static void drawString(String text, int x, int y, int z, int canvasWidth, int canvasHeight, int color, boolean drawShadow) {
        RenderHelper.drawString(text, x + (canvasWidth - RenderHelper.getStringWidth(text)) / 2, y + (canvasHeight - RenderHelper.getMC().field_71466_p.field_78288_b) / 2, z, color, drawShadow);
    }

    public static void drawString(String text, int x, int y, int z, int color, boolean drawShadow) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)32826);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        RenderHelper.getMC().field_71466_p.func_85187_a(text, x, y, color, drawShadow);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-z));
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
    }

    public static void drawSplitString(String text, int x, int y, int color, boolean drawShadow) {
        String[] splits = text.split("<br>");
        for (int i = 0; i < splits.length; ++i) {
            RenderHelper.getMC().field_71466_p.func_85187_a(splits[i], x, y + i * 10, color, drawShadow);
        }
    }

    public static void drawLine(int color, int startX, int startY, int endX, int endY, float width, int zLevel) {
        RenderHelper.drawLine(color, 1.0f, startX, startY, endX, endY, width, zLevel);
    }

    public static void drawLine(int color, float alpha, int startX, int startY, int endX, int endY, float width, int zLevel) {
        Color rgb = RenderHelper.getRGBFromColor(color);
        rgb.setAlpha((int)(alpha * 255.0f));
        RenderHelper.drawLine(rgb, startX, startY, endX, endY, width, zLevel);
    }

    public static Color getRGBFromColor(int color) {
        return new Color((0xFF0000 & color) >> 16, (0xFF00 & color) >> 8, 0xFF & color);
    }

    public static void drawLine(Color color, int startX, int startY, int endX, int endY, float width, int zLevel) {
        float multiplier = 0.003921569f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)(multiplier * (float)color.getRed()), (float)(multiplier * (float)color.getGreen()), (float)(multiplier * (float)color.getBlue()), (float)(multiplier * (float)color.getAlpha()));
        GL11.glLineWidth((float)width);
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)startX, (float)startY, (float)zLevel);
        GL11.glVertex3f((float)endX, (float)endY, (float)zLevel);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void drawRectangle(int color, int x, int y, int z, int width, int height) {
        RenderHelper.drawRectangle(color, 1.0f, x, y, z, width, height);
    }

    public static void drawRectangle(int color, float alpha, int x, int y, int z, int width, int height) {
        Color rgb = RenderHelper.getRGBFromColor(color);
        rgb.setAlpha((int)(alpha * 255.0f));
        RenderHelper.drawRectangle(rgb, x, y, z, width, height);
    }

    public static void drawRectangle(Color color, int x, int y, int z, int width, int height) {
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        RenderHelper.drawQuad(x, y, z, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    public static void drawRectangle(ResourceLocation texture, int x, int y, int z, int width, int height, int u, int v) {
        RenderHelper.drawRectangle(texture, x, y, z, width, height, u, v, 256, 256);
    }

    public static void drawRectangle(ResourceLocation texture, int x, int y, int z, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        RenderHelper.bindTexture(texture);
        RenderHelper.drawRectangle(x, y, z, width, height, u, v, textureWidth, textureHeight);
    }

    public static void drawRectangle(int x, int y, int z, int width, int height, int u, int v) {
        RenderHelper.drawRectangle(x, y, z, width, height, u, v, 256, 256);
    }

    public static void drawRectangle(int x, int y, int z, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        RenderHelper.drawQuad(x, y, z, width, height, (float)u / (float)textureWidth, (float)v / (float)textureHeight, (float)(u + width) / (float)textureWidth, (float)(v + height) / (float)textureHeight);
    }

    public static void drawQuad(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), (double)z, (double)u, (double)vMax);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)z, (double)uMax, (double)vMax);
        tessellator.func_78374_a((double)(x + width), (double)y, (double)z, (double)uMax, (double)v);
        tessellator.func_78374_a((double)x, (double)y, (double)z, (double)u, (double)v);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
    }

    public static void drawRectangleRepeated(ResourceLocation texture, int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileWidth, int tileHeight) {
        RenderHelper.bindTexture(texture);
        RenderHelper.drawRectangleRepeated(x, y, z, width, height, u, v, uMax, vMax, tileWidth, tileHeight);
    }

    public static void drawRectangleRepeated(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileWidth, int tileHeight) {
        RenderHelper.loadShaders();
        shaders.activate();
        shaders.setUniform1i("tex", 0);
        shaders.setUniform2f("iconOffset", u, v);
        shaders.setUniform2f("iconSize", uMax - u, vMax - v);
        RenderHelper.drawQuad(x, y, z, width, height, 0.0f, 0.0f, (float)RenderHelper.getScaledWidth(width) / (float)tileWidth, (float)RenderHelper.getScaledHeight(height) / (float)tileHeight);
        shaders.deactivate();
    }

    public static void drawRectangleXRepeated(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileWidth) {
        RenderHelper.loadShaders();
        shaders.activate();
        shaders.setUniform1i("tex", 0);
        shaders.setUniform2f("iconOffset", u, 0.0f);
        shaders.setUniform2f("iconSize", uMax - u, 1.0f);
        RenderHelper.drawQuad(x, y, z, width, height, 0.0f, v, (float)RenderHelper.getScaledWidth(width) / (float)tileWidth, vMax);
        shaders.deactivate();
    }

    public static void drawRectangleYRepeated(int x, int y, int z, int width, int height, float u, float v, float uMax, float vMax, int tileHeight) {
        RenderHelper.loadShaders();
        shaders.activate();
        shaders.setUniform1i("tex", 0);
        shaders.setUniform2f("iconOffset", 0.0f, v);
        shaders.setUniform2f("iconSize", 1.0f, vMax - v);
        RenderHelper.drawQuad(x, y, z, width, height, u, 0.0f, uMax, (float)RenderHelper.getScaledHeight(height) / (float)tileHeight);
        shaders.deactivate();
    }

    public static void drawIcon(IIcon icon, int x, int y, int z, int width, int height) {
        RenderHelper.drawQuad(x, y, z, width, height, icon.func_94209_e(), icon.func_94206_g(), icon.func_94212_f(), icon.func_94210_h());
    }

    public static void loadShaders() {
        if (shaders == null) {
            shaders = new ShaderSystem();
            shaders.addShader(REPEAT_SHADER, 35632);
        }
    }

    public static ScaledResolution getScaledResolution() {
        return new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
    }

    public static int getScaledWidth(int width) {
        return width / RenderHelper.getScaledResolution().func_78325_e();
    }

    public static int getScaledHeight(int height) {
        return height / RenderHelper.getScaledResolution().func_78325_e();
    }

    public static int computeGuiScale() {
        Minecraft mc = Minecraft.func_71410_x();
        int scaleFactor = 1;
        int k = mc.field_71474_y.field_74335_Z;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }
}

