/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.multiblock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class MultiBlock
implements Iterable<BlockState>,
IBlockAccess {
    protected Map<BlockPos, BlockState> states = new HashMap<BlockPos, BlockState>();
    protected BlockPos offset;
    protected int rotation;

    public void setOffset(BlockPos offset) {
        this.offset = offset;
        this.buildStates();
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isFromMultiblock(BlockPos pos) {
        return this.getBlockState(pos) != null;
    }

    public BlockState getBlockState(BlockPos pos) {
        pos = pos.rotate(4 - this.rotation);
        return this.states.get(pos);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        for (BlockState state : this) {
            BlockPos p = state.getPos().add(pos);
            if (state.getBlock().func_149742_c(world, p.getX(), p.getY(), p.getZ())) continue;
            return false;
        }
        return true;
    }

    public void placeBlocks(World world, BlockPos pos) {
        for (BlockState state : this) {
            if ((state = state.rotate(this.rotation).offset(pos)).getPos().equals(pos)) continue;
            state.placeBlock(world, 2);
            state.rotateInWorld(world, this.rotation);
        }
    }

    public void breakBlocks(World world, BlockPos pos) {
        for (BlockState state : this) {
            if ((state = state.rotate(this.rotation).offset(pos)).getPos().equals(pos)) continue;
            state.breakBlock(world, 2);
        }
    }

    public boolean isComplete(World world, BlockPos pos) {
        return this.isComplete(world, pos, null);
    }

    public boolean isComplete(World world, BlockPos pos, BlockState newState) {
        for (BlockState state : this) {
            if ((state = state.offset(pos)).matchesWorld((IBlockAccess)world) || newState != null && state.equals(newState)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<BlockState> iterator() {
        return this.states.values().iterator();
    }

    protected abstract void buildStates();

    public Block func_147439_a(int x, int y, int z) {
        BlockState state = this.getBlockState(new BlockPos(x, y, z));
        if (state == null) {
            return Blocks.field_150350_a;
        }
        return state.getBlock();
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        return null;
    }

    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        return 0xF000F0;
    }

    public int func_72805_g(int x, int y, int z) {
        BlockState state = this.getBlockState(new BlockPos(x, y, z));
        if (state == null) {
            return 0;
        }
        return state.getMetadata();
    }

    public int func_72879_k(int x, int y, int z, int directionIn) {
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public BiomeGenBase func_72807_a(int x, int z) {
        return null;
    }

    public int func_72800_K() {
        return 0;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }
}

