/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import net.malisis.core.util.MultiBlock;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.movement.ForcefieldMovement;
import net.malisis.doors.door.sound.SilentDoorSound;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class ForcefieldTileEntity
extends DoorTileEntity
implements MultiBlock.IProvider {
    private MultiBlock multiBlock;

    public ForcefieldTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(ForcefieldMovement.class));
        descriptor.setSound(DoorRegistry.getSound(SilentDoorSound.class));
        descriptor.setDoubleDoor(false);
        descriptor.setOpeningTime(0);
        this.setDescriptor(descriptor);
    }

    private int getOriginMetadata() {
        if (this.multiBlock == null) {
            return 0;
        }
        return this.func_145831_w().func_72805_g(this.multiBlock.getX(), this.multiBlock.getY(), this.multiBlock.getZ());
    }

    @Override
    public boolean isTopBlock(int x, int y, int z) {
        return false;
    }

    @Override
    public int getDirection() {
        return this.multiBlock.getDirection().ordinal();
    }

    @Override
    public boolean isOpened() {
        return (this.getOriginMetadata() & 4) != 0;
    }

    @Override
    public boolean isReversed() {
        return false;
    }

    @Override
    public boolean isPowered() {
        return false;
    }

    @Override
    public DoorState getState() {
        ForcefieldTileEntity te = MultiBlock.getOriginProvider(this);
        if (te == null) {
            return DoorState.CLOSED;
        }
        if (te != this) {
            return te.getState();
        }
        return super.getState();
    }

    @Override
    public void openOrCloseDoor() {
        ForcefieldTileEntity te = MultiBlock.getOriginProvider(this);
        if (te == null) {
            return;
        }
        if (te != this) {
            te.openOrCloseDoor();
            return;
        }
        if (this.getState() != DoorState.CLOSED && this.getState() != DoorState.OPENED) {
            return;
        }
        super.openOrCloseDoor();
    }

    @Override
    public void setMultiBlock(MultiBlock multiBlock) {
        this.multiBlock = multiBlock;
    }

    @Override
    public MultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        if (this.multiBlock != null) {
            this.multiBlock.setWorld(world);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.multiBlock = new MultiBlock(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.multiBlock != null) {
            this.multiBlock.writeToNBT(tag);
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.multiBlock != null) {
            return this.multiBlock.getWorldBounds();
        }
        return super.getRenderBoundingBox();
    }
}

