/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.malisis.doors.door.DoorState;
import net.malisis.doors.door.block.CollisionHelperBlock;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.MultiTile;
import net.malisis.doors.network.FrameUpdateMessage;
import net.malisis.doors.renderer.CustomDoorBoundingBoxRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.lwjgl.input.Keyboard;

public class DoorEventHandlerClient {
    public CustomDoorBoundingBoxRenderer cdbbRenderer = new CustomDoorBoundingBoxRenderer();

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        World world = event.player.field_70170_p;
        MovingObjectPosition target = event.target;
        if (target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            DoorTileEntity doorTile;
            DoorState state;
            MultiTile multi;
            int x = target.field_72311_b;
            int y = target.field_72312_c;
            int z = target.field_72309_d;
            Block block = world.func_147439_a(x, y, z);
            if (!(block instanceof CollisionHelperBlock)) {
                return;
            }
            CollisionHelperBlock collisionHelper = (CollisionHelperBlock)block;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof MultiTile && (tileEntity = (multi = (MultiTile)tileEntity).getMainBlockTile()) instanceof DoorTileEntity && ((state = (doorTile = (DoorTileEntity)tileEntity).getState()) == DoorState.OPENED || state == DoorState.OPENING || state == DoorState.CLOSING)) {
                event.setCanceled(true);
                this.cdbbRenderer.renderOpenDoorBoundingBox(world, collisionHelper, event.player, event.partialTicks, target);
            }
        }
    }

    @SubscribeEvent
    public void onClientInteract(PlayerInteractEvent event) {
        TileEntity tileEntity;
        if (!event.world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        if (player.func_70093_af() && event.action.equals((Object)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && (tileEntity = this.getTileEntityLookingAt(player)) instanceof MultiTile) {
            MultiTile multiTile = (MultiTile)tileEntity;
            if (Keyboard.isKeyDown((int)29)) {
                ItemStack heldStack = player.func_70694_bm();
                if (heldStack == null) {
                    return;
                }
                Block block = Block.func_149634_a((Item)heldStack.func_77973_b());
                int damageValue = heldStack.func_77960_j();
                if (block != null) {
                    event.setCanceled(true);
                    FrameUpdateMessage.SendFrameUpdateMessage(multiTile, block, damageValue);
                }
            }
        }
    }

    private TileEntity getTileEntityLookingAt(EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        double maxReach = mc.field_71442_b.func_78757_d();
        Vec3 eyePosition = player.func_70666_h(1.0f);
        Vec3 lookVector = player.func_70676_i(1.0f);
        Vec3 endPosition = eyePosition.func_72441_c(lookVector.field_72450_a * maxReach, lookVector.field_72448_b * maxReach, lookVector.field_72449_c * maxReach);
        MovingObjectPosition rayTraceResult = mc.field_71441_e.func_72933_a(eyePosition, endPosition);
        if (rayTraceResult != null && rayTraceResult.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return mc.field_71441_e.func_147438_o(rayTraceResult.field_72311_b, rayTraceResult.field_72312_c, rayTraceResult.field_72309_d);
        }
        return null;
    }
}

