/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator;

import com.gtnewhorizon.gtnhlib.config.Config;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;

public class GlobalMMConfig {
    public static boolean DEVENV = false;

    public static void init() {
        try {
            ConfigurationManager.registerConfig(InteractionConfig.class);
            ConfigurationManager.registerConfig(RenderingConfig.class);
            ConfigurationManager.registerConfig(DebugConfig.class);
            ConfigurationManager.registerConfig(BuildingConfig.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        try {
            Class.forName("net.minecraft.server.MinecraftServer");
            DEVENV = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Config(modid="matter-manipulator", category="interaction")
    public static class InteractionConfig {
        @Config.Comment(value={"Clear the paste region when the copy or cut regions are marked"})
        @Config.DefaultBoolean(value=true)
        @Config.Name(value="Auto Clear Paste")
        public static boolean pasteAutoClear;
        @Config.Comment(value={"Clear the transform and the stacking amount when the coordinates are cleared"})
        @Config.DefaultBoolean(value=true)
        @Config.Name(value="Clear Transform")
        public static boolean resetTransform;
    }

    @Config(modid="matter-manipulator", category="rendering")
    public static class RenderingConfig {
        @Config.Comment(value={"Controls how many blocks are shown in the preview. Client only."})
        @Config.DefaultInt(value=1000000)
        @Config.Name(value="Max Hints Shown")
        public static int maxHints;
        @Config.Comment(value={"Controls the duration of the build status warning/error hints (seconds). Client only. Set to 0 to never clear hints."})
        @Config.DefaultInt(value=60)
        @Config.Name(value="Build Status Timeout")
        public static int statusExpiration;
        @Config.Comment(value={"When true, hints will always be drawn on top of the terrain. Client only."})
        @Config.DefaultBoolean(value=true)
        @Config.Name(value="Draw Hints On Top")
        public static boolean hintsOnTop;
    }

    @Config(modid="matter-manipulator", category="debug")
    public static class DebugConfig {
        @Config.DefaultBoolean(value=false)
        @Config.Name(value="Enable Debug Logging")
        public static boolean debug;
    }

    @Config(modid="matter-manipulator", category="building")
    public static class BuildingConfig {
        @Config.Comment(value={"Empty ME Output Hatches/Busses when they're removed. Server only."})
        @Config.DefaultBoolean(value=true)
        @Config.Name(value="Empty ME Outputs")
        public static boolean meEmptying;
        @Config.Comment(value={"High values may cause world desync and lag. Server only. Requires restart."})
        @Config.DefaultInt(value=256)
        @Config.RangeInt(min=1)
        @Config.Name(value="MK3 Block Place Speed")
        @Config.RequiresMcRestart
        public static int mk3BlocksPerPlace;
    }
}

