/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public interface BooleanProperty
extends BlockProperty<Boolean> {
    @Override
    default public Boolean getValue(World world, int x, int y, int z) {
        return this.getBoolean(world, x, y, z);
    }

    @Override
    default public void setValue(World world, int x, int y, int z, Boolean value) {
        this.setBoolean(world, x, y, z, value);
    }

    @Override
    default public Boolean parse(String text) throws Exception {
        return Boolean.parseBoolean(text);
    }

    public boolean getBoolean(World var1, int var2, int var3, int var4);

    public void setBoolean(World var1, int var2, int var3, int var4, boolean var5);

    public static BooleanProperty range(final String name, final int offset, final int size) {
        return new BooleanProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                int meta = world.func_72805_g(x, y, z);
                return meta >= offset && meta < offset + size;
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                int meta = world.func_72805_g(x, y, z);
                if (meta >= offset && meta < offset + size) {
                    meta -= offset;
                }
                if (value) {
                    meta += offset;
                }
                world.func_72921_c(x, y, z, meta, 2);
            }
        };
    }

    public static FlagBooleanProperty flag(String name, int flag) {
        return new FlagBooleanProperty(name, flag);
    }

    public static BooleanProperty blocks(final String name, final Block inactive, final Block active) {
        return new BooleanProperty(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean getBoolean(World world, int x, int y, int z) {
                return world.func_147439_a(x, y, z) == active;
            }

            @Override
            public void setBoolean(World world, int x, int y, int z, boolean value) {
                world.func_147465_d(x, y, z, value ? active : inactive, world.func_72805_g(x, y, z), 2);
            }
        };
    }

    public static class FlagBooleanProperty
    implements BooleanProperty {
        public final String name;
        public final int flag;

        public FlagBooleanProperty(String name, int flag) {
            this.name = name;
            this.flag = flag;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean getBoolean(World world, int x, int y, int z) {
            int meta = world.func_72805_g(x, y, z);
            return (meta & this.flag) == this.flag;
        }

        @Override
        public void setBoolean(World world, int x, int y, int z, boolean value) {
            int meta = world.func_72805_g(x, y, z);
            meta &= ~this.flag;
            if (value) {
                meta |= this.flag;
            }
            world.func_72921_c(x, y, z, meta, 2);
        }
    }
}

