/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import com.google.auto.value.AutoValue;
import com.recursive_pineapple.matter_manipulator.common.utils.AutoValue_FluidId;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@AutoValue
public abstract class FluidId {
    public static FluidId create(NBTTagCompound tag) {
        return new AutoValue_FluidId(FluidRegistry.getFluid((String)tag.func_74779_i("FluidName")), tag.func_150297_b("Tag", 10) ? tag.func_74775_l("Tag") : null, tag.func_150297_b("Amount", 3) ? Integer.valueOf(tag.func_74762_e("Amount")) : null);
    }

    public NBTTagCompound writeToNBT() {
        Integer amount;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("FluidName", this.fluid().getName());
        if (this.nbt() != null) {
            tag.func_74782_a("Tag", (NBTBase)this.nbt());
        }
        if ((amount = this.amount()) != null) {
            tag.func_74768_a("Amount", amount.intValue());
        }
        return tag;
    }

    public static FluidId create(FluidStack fluidStack) {
        return FluidId.createWithCopy(fluidStack.getFluid(), null, fluidStack.tag);
    }

    public static FluidId createWithAmount(FluidStack fluidStack) {
        return FluidId.createWithCopy(fluidStack.getFluid(), fluidStack.amount, fluidStack.tag);
    }

    public static FluidId create(Fluid fluid) {
        return FluidId.createNoCopy(fluid, null, null);
    }

    public static FluidId createWithCopy(Fluid fluid, Integer amount, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            nbt = (NBTTagCompound)nbt.func_74737_b();
        }
        return new AutoValue_FluidId(fluid, nbt, amount);
    }

    public static FluidId createNoCopy(Fluid fluid, Integer amount, @Nullable NBTTagCompound nbt) {
        return new AutoValue_FluidId(fluid, nbt, amount);
    }

    protected abstract Fluid fluid();

    @Nullable
    protected abstract NBTTagCompound nbt();

    @Nullable
    protected abstract Integer amount();

    @Nonnull
    public FluidStack getFluidStack() {
        NBTTagCompound nbt = this.nbt();
        return new FluidStack(this.fluid(), 1, nbt != null ? (NBTTagCompound)nbt.func_74737_b() : null);
    }

    @Nonnull
    public FluidStack getFluidStack(int amount) {
        NBTTagCompound nbt = this.nbt();
        return new FluidStack(this.fluid(), amount, nbt != null ? (NBTTagCompound)nbt.func_74737_b() : null);
    }
}

